/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model.util;

import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.model.timesignature.TimeSignatureList;

public class TimeUtils {
    static final int NORMAL = 0;
    static final int CMODE = 1;
    static int defaultMode = 1;
    int ticksPerBeat;
    TimeSignatureList timeSig;
    static int barOff = 0;
    static int beatOff = 0;

    public TimeUtils(ProjectContainer proj) {
        this(proj.getSequence().getResolution(), proj.getTimeSignatureList());
    }

    public TimeUtils(int ticksPerBeat, TimeSignatureList timeSig) {
        this.ticksPerBeat = ticksPerBeat;
        this.timeSig = timeSig;
        TimeUtils.setMode(defaultMode);
    }

    public static void setMode(int key) {
        switch (key) {
            case 0: {
                barOff = 1;
                beatOff = 1;
                break;
            }
            case 1: {
                barOff = 0;
                beatOff = 0;
                break;
            }
            default: {
                try {
                    throw new Exception("Unknown display mode");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String tickToBarBeatTick(long tick) {
        boolean minus;
        boolean bl = minus = tick < 0L;
        if (minus) {
            tick = -tick;
        }
        long beats = tick / (long)this.ticksPerBeat;
        long tickBit = tick % (long)this.ticksPerBeat;
        TimeSignatureList.TimeSignatureEvent ev = this.timeSig.getEventAtBeat((int)beats);
        int bar = (int)((long)ev.bar + (beats - (long)ev.beat) / (long)ev.beatsPerBar);
        beats = (beats - (long)ev.beat) % (long)ev.beatsPerBar;
        String s = bar + barOff + "." + (beats + (long)beatOff) + ":" + String.format("%03d", tickBit);
        if (minus) {
            s = "-" + s;
        }
        return s;
    }

    public String tickToBarBeat(long tick) {
        boolean minus = false;
        if (tick < 0L) {
            minus = true;
            tick = -tick;
        }
        long beats = tick / (long)this.ticksPerBeat;
        long tickBit = tick % (long)this.ticksPerBeat;
        assert (tickBit == 0L);
        TimeSignatureList.TimeSignatureEvent ev = this.timeSig.getEventAtBeat((int)beats);
        String s = ev.bar + barOff + "." + (beats - (long)ev.beat + (long)beatOff);
        if (minus) {
            return "-" + s;
        }
        return s;
    }

    public String tickToBeatTick(long tick) {
        boolean minus = false;
        if (tick < 0L) {
            minus = true;
            tick = -tick;
        }
        long beats = tick / (long)this.ticksPerBeat;
        long tickBit = tick % (long)this.ticksPerBeat;
        String s = beats + (long)beatOff + ":" + String.format("%03d", tickBit);
        if (minus) {
            return "-" + s;
        }
        return s;
    }

    public int barAtTick(long tick) {
        long beats = tick / (long)this.ticksPerBeat;
        long tickBit = tick % (long)this.ticksPerBeat;
        if (tickBit != 0L) {
            return -1;
        }
        TimeSignatureList.TimeSignatureEvent ev = this.timeSig.getEventAtBeat((int)beats);
        if (ev == null) {
            return -1;
        }
        int bb = (int)((beats - (long)ev.beat) % (long)ev.beatsPerBar);
        if (bb != 0) {
            return -1;
        }
        return (int)((long)(ev.bar + barOff) + (beats - (long)ev.beat) / (long)ev.beatsPerBar);
    }

    public long barBeatTickToTick(String str) {
        try {
            long sign;
            str = str.trim();
            if (str.length() == 0) {
                return 0L;
            }
            long l = sign = str.charAt(0) == '-' ? -1L : 1L;
            if (sign == -1L && (str = str.substring(1).trim()).length() == 0) {
                return 0L;
            }
            String[] toks = str.split("[:|.]");
            switch (toks.length) {
                case 1: {
                    if (str.charAt(0) == ':') {
                        return sign * Long.parseLong(toks[0]);
                    }
                    if (str.indexOf(46) > 0) {
                        if (sign < 0L) {
                            throw new Exception(" negative times are broken ");
                        }
                        int beat = this.timeSig.getBeatAtBar(Integer.parseInt(toks[0]) - barOff);
                        return sign * (long)beat * (long)this.ticksPerBeat;
                    }
                    return sign * (Long.parseLong(toks[0]) - (long)beatOff) * (long)this.ticksPerBeat;
                }
                case 2: {
                    if (str.charAt(0) == '.') {
                        return sign * (Long.parseLong(toks[1]) - (long)beatOff) * (long)this.ticksPerBeat;
                    }
                    if (str.charAt(0) == ':') {
                        return sign * Long.parseLong(toks[1]);
                    }
                    if (str.indexOf(46) > 0) {
                        if (sign < 0L) {
                            throw new Exception(" negative times are broken ");
                        }
                        int beat = this.timeSig.getBeatAtBar(Integer.parseInt(toks[0]) - barOff);
                        return sign * (long)(beat + (Integer.parseInt(toks[1]) - beatOff)) * (long)this.ticksPerBeat;
                    }
                    return sign * ((Long.parseLong(toks[0]) - (long)beatOff) * (long)this.ticksPerBeat + Long.parseLong(toks[1]));
                }
                case 3: {
                    if (!toks[0].equals("")) {
                        if (sign < 0L) {
                            throw new Exception(" negative times are broken ");
                        }
                        int beat = this.timeSig.getBeatAtBar(Integer.parseInt(toks[0]) - barOff);
                        return sign * (long)(beat + (Integer.parseInt(toks[1]) - beatOff)) * (long)this.ticksPerBeat + Long.parseLong(toks[2]);
                    }
                    return sign * ((Long.parseLong(toks[1]) - (long)beatOff) * (long)this.ticksPerBeat + Long.parseLong(toks[2]));
                }
            }
            throw new Exception("error in time format >" + str + "<");
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public long beatTickToTick(String s) {
        int ticks;
        int beats;
        int sgn = 1;
        if ((s = s.trim()).length() == 0) {
            return 0L;
        }
        char sgnch = s.charAt(0);
        if (sgnch == '-') {
            sgn = -1;
            s = s.substring(1);
        } else if (sgnch == '+') {
            s = s.substring(1);
        }
        int pos = s.indexOf(58);
        if (pos == -1) {
            try {
                return (long)sgn * Long.parseLong(s);
            }
            catch (NumberFormatException nfe) {
                return 0L;
            }
        }
        String beatsStr = s.substring(0, pos);
        String ticksStr = s.substring(pos + 1);
        try {
            beats = Integer.parseInt(beatsStr);
        }
        catch (NumberFormatException nfe1) {
            beats = 0;
        }
        try {
            ticks = Integer.parseInt(ticksStr);
        }
        catch (NumberFormatException nfe1) {
            ticks = 0;
        }
        return (long)sgn * ((long)beats * (long)this.ticksPerBeat + (long)ticks);
    }

    public double tickToFloatBeat(long tick) {
        return tick / (long)this.ticksPerBeat;
    }

    public long ticksPerBeat() {
        return this.ticksPerBeat;
    }

    public int beatsPerBar(long tick) {
        long beats = tick / (long)this.ticksPerBeat;
        TimeSignatureList.TimeSignatureEvent ev = this.timeSig.getEventAtBeat((int)beats);
        return ev.beatsPerBar;
    }

    public long startTickOfBar(int bar) {
        return this.timeSig.getBeatAtBar(bar) * this.ticksPerBeat;
    }

    public long beatToTick(double beat) {
        return Math.round((double)this.ticksPerBeat * beat);
    }

    public static void main(String[] args) {
        TimeSignatureList list = new TimeSignatureList();
        list.add(0, 4);
        TimeUtils time = new TimeUtils(60, list);
        String[] tests = new String[]{"1.", "234", "2:234", ":234", "17.3:031", "14.", ".3", ".3:004", "2:", "15.1:"};
        TimeUtils.setMode(1);
        for (String str : tests) {
            System.out.println(str + " = " + time.tickToBarBeatTick(time.barBeatTickToTick(str)));
        }
        TimeUtils.setMode(0);
        for (String str : tests) {
            System.out.println(str + " = " + time.tickToBarBeatTick(time.barBeatTickToTick(str)));
        }
    }
}

