/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.patchname;

import com.frinika.sequencer.patchname.MyPatch;
import com.frinika.sequencer.patchname.Node;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import javax.sound.midi.Instrument;
import javax.sound.midi.Patch;
import javax.sound.midi.Synthesizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchNameMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Vector<Node> topList = new Vector();

    public PatchNameMap(InputStream str) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(str));
        boolean readPatches = false;
        while ((line = reader.readLine()) != null) {
            int opB = line.indexOf(91);
            if (opB == -1) continue;
            int clB = line.indexOf(93);
            if (clB == -1) {
                throw new Exception(" Parse error " + line + "<");
            }
            String cmd = line.substring(opB + 1, clB);
            String rest = line.substring(clB + 1);
            String name = rest.trim();
            if (!readPatches) {
                if (!cmd.equals("define patchnames")) continue;
                readPatches = true;
                continue;
            }
            if (cmd.charAt(0) == 'p') {
                this.patchName(cmd, name);
                continue;
            }
            if (cmd.charAt(0) != 'g') continue;
            this.groupName(cmd, name);
        }
    }

    public PatchNameMap(Synthesizer synthesizer, int channel) {
        Instrument[] availableInstruments;
        Instrument[] loadedins = synthesizer.getLoadedInstruments();
        Instrument[] availins = synthesizer.getAvailableInstruments();
        if (loadedins == availins) {
            availableInstruments = loadedins;
        } else {
            int i;
            availableInstruments = new Instrument[loadedins.length + availins.length];
            int ix = 0;
            for (i = 0; i < loadedins.length; ++i) {
                availableInstruments[ix++] = loadedins[i];
            }
            for (i = 0; i < availins.length; ++i) {
                availableInstruments[ix++] = availins[i];
            }
        }
        Method getChannels = null;
        Method getKeys = null;
        if (availableInstruments.length > 0) {
            try {
                getChannels = availableInstruments[0].getClass().getMethod("getChannels", new Class[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                getKeys = availableInstruments[0].getClass().getMethod("getKeys", new Class[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (Instrument instr : availableInstruments) {
            Patch p = instr.getPatch();
            boolean[] channels = null;
            if (getChannels != null) {
                try {
                    channels = (boolean[])getChannels.invoke((Object)instr, new Object[0]);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            String[] keynames = null;
            if (getKeys != null) {
                try {
                    keynames = (String[])getKeys.invoke((Object)instr, new Object[0]);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (channels != null && !channels[channel]) continue;
            MyPatch patch = new MyPatch(p.getProgram(), p.getBank() >> 7, p.getBank() & 0x7F);
            Node node = new Node(instr.getName(), patch);
            node.keynames = keynames;
            this.listAtLevel(0).add(node);
        }
    }

    private void groupName(String cmd, String name) throws IOException {
        int level = Integer.parseInt(cmd.substring(1));
        this.listAtLevel(level).add(new Node(name, new Vector()));
    }

    private Vector<Node> listAtLevel(int level) {
        if (level == 1) {
            return this.topList;
        }
        Vector p = this.topList;
        while (level > 1) {
            p = (Vector)p.lastElement().getData();
            --level;
        }
        return p;
    }

    private void patchName(String cmd, String name) throws IOException {
        String[] toks = cmd.split(",");
        int level = Integer.parseInt(toks[0].substring(1));
        int prog = Integer.parseInt(toks[1].trim());
        int msb = Integer.parseInt(toks[2].trim());
        int lsb = Integer.parseInt(toks[3].trim());
        MyPatch patch = new MyPatch(prog, msb, lsb);
        this.listAtLevel(level).add(new Node(name, patch));
    }

    public List<MyPatch> getPatchesWithNamesLike(String name) {
        Vector<MyPatch> list = new Vector<MyPatch>();
        this.getPatchesWithNameLike(name, this.topList, list);
        return list;
    }

    private void getPatchesWithNameLike(String name, Vector<Node> root, List<MyPatch> list) {
        for (Node o : root) {
            if (o.getData() instanceof Vector) {
                this.getPatchesWithNameLike(name, (Vector)o.getData(), list);
                continue;
            }
            if (!o.toString().toLowerCase().contains(name)) continue;
            list.add((MyPatch)o.getData());
        }
    }

    boolean contians(String name, Vector<Node> searchMe, Vector<Vector<Node>> ret) {
        for (Node o : searchMe) {
            if (o.getData() instanceof Vector) {
                if (!this.contians(name, (Vector)o.getData(), ret)) continue;
                ret.insertElementAt((Vector)o.getData(), 0);
                System.out.println(" in list " + o.getData());
                return true;
            }
            if (name.equals(o.toString())) {
                System.out.println(" FOUND NAME " + name);
                return true;
            }
            System.out.println(" It's not " + o.toString());
        }
        return false;
    }

    public Vector<Node> getList() {
        return this.topList;
    }
}

