/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.settings;

import com.frinika.global.FrinikaConfig;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.org.toot.audio.server.ExtendedAudioServer;

class AudioServerIOPanel
extends JPanel {
    final String outConfigStr;
    final JComboBox devOut;

    AudioServerIOPanel(ExtendedAudioServer audioServer) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridy = 0;
        c.gridx = 0;
        this.add((Component)new JLabel("Output:"), c);
        this.devOut = new JComboBox();
        ++c.gridx;
        this.add((Component)this.devOut, c);
        this.outConfigStr = audioServer.getConfigKey() + ".output";
        String outStr = FrinikaConfig.getProperty(this.outConfigStr);
        System.out.println("FrinikaConfigure: " + this.outConfigStr + "=" + outStr);
        List list = audioServer.getAvailableOutputNames();
        for (String str : list) {
            this.devOut.addItem(str);
            if (!str.equals(outStr)) continue;
            this.devOut.setSelectedItem(str);
        }
        if (this.devOut.getSelectedItem() == null) {
            this.devOut.setSelectedIndex(0);
        }
    }

    void done() {
        FrinikaConfig.setProperty(this.outConfigStr, this.devOut.getSelectedItem().toString());
        FrinikaConfig.store();
    }
}

