/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.settings;

import com.frinika.global.FrinikaConfig;
import com.frinika.toot.javasoundmultiplexed.MultiplexedJavaSoundAudioServer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class MultiPlexAudioServerIOPanel
extends JPanel {
    final JComboBox devOut;
    final JComboBox devIn;
    final String inConfigStr;
    final String outConfigStr;
    final MultiplexedJavaSoundAudioServer audioServer;

    MultiPlexAudioServerIOPanel(MultiplexedJavaSoundAudioServer s) {
        this.audioServer = s;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridy = 0;
        c.gridx = 0;
        this.add((Component)new JLabel("Output Device:"), c);
        this.devOut = new JComboBox();
        ++c.gridx;
        this.add((Component)this.devOut, c);
        this.outConfigStr = s.getConfigKey() + ".outputDevice";
        String outStr = FrinikaConfig.getProperty(this.outConfigStr);
        System.out.println("FrinikaCongigure:" + this.outConfigStr + "=" + outStr);
        List list = this.audioServer.getOutDeviceList();
        for (String str : list) {
            this.devOut.addItem(str);
            if (str != outStr) continue;
            this.devOut.setSelectedItem(str);
        }
        list = s.getInDeviceList();
        list.add(0, "NONE");
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Input Device:"), c);
        this.devIn = new JComboBox();
        ++c.gridx;
        this.add((Component)this.devIn, c);
        this.inConfigStr = s.getConfigKey() + ".inputDevice";
        String inStr = FrinikaConfig.getProperty(this.inConfigStr);
        list = s.getInDeviceList();
        list.add("NONE");
        for (String str : list) {
            this.devIn.addItem(str);
            if (!str.equals(inStr)) continue;
            this.devIn.setSelectedItem(str);
        }
        if (this.devIn.getSelectedItem() == null) {
            this.devIn.setSelectedIndex(0);
        }
        if (this.devOut.getSelectedItem() == null) {
            this.devOut.setSelectedIndex(0);
        }
    }

    void done() {
        this.audioServer.setOutDevice(this.devOut.getSelectedItem().toString());
        this.audioServer.setInDevice(this.devIn.getSelectedItem().toString());
        FrinikaConfig.setProperty(this.outConfigStr, this.devOut.getSelectedItem().toString());
        FrinikaConfig.setProperty(this.inConfigStr, this.devIn.getSelectedItem().toString());
        FrinikaConfig.store();
    }
}

