/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;

public class SettingsDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static SettingsDialog instance = null;

    public static void main(String[] args) {
        new SettingsDialog().setVisible(true);
    }

    public static void showSettings() {
        if (instance == null) {
            instance = new SettingsDialog();
        }
        instance.setAlwaysOnTop(true);
        instance.setModal(false);
        instance.setVisible(true);
    }

    public static void showSettingsModal() {
        if (instance == null) {
            instance = new SettingsDialog();
        }
        instance.setAlwaysOnTop(false);
        instance.setModal(true);
        instance.setVisible(true);
    }

    public SettingsDialog() {
        this.setTitle("Settings");
        JPanel contentpane = new JPanel();
        contentpane.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        contentpane.setLayout(new BorderLayout());
        JPanel audiogroup = new JPanel();
        audiogroup.setBorder(BorderFactory.createTitledBorder("Audio"));
        audiogroup.setLayout(new FlowLayout(0, 0, 0));
        JPanel groupcontent = new JPanel();
        audiogroup.add(groupcontent);
        groupcontent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        groupcontent.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridy = 0;
        c.gridx = 0;
        groupcontent.add((Component)new JLabel("Output Device:"), c);
        String[] devices = new String[]{"Java Sound Device"};
        c.gridx = 1;
        groupcontent.add(new JComboBox<String>(devices), c);
        c.gridy = 1;
        c.gridx = 0;
        groupcontent.add((Component)new JLabel("Sample Rate:"), c);
        JComboBox<String> ratebox = new JComboBox<String>(new String[]{"48000", "44100", "22050"});
        ratebox.setEditable(true);
        c.gridx = 1;
        groupcontent.add(ratebox, c);
        c.gridy = 2;
        c.gridx = 0;
        groupcontent.add((Component)new JLabel("Channels:"), c);
        c.gridx = 1;
        groupcontent.add(new JComboBox<String>(new String[]{"2 Stereo", "1 Mono"}), c);
        c.gridy = 3;
        c.gridx = 0;
        groupcontent.add((Component)new JLabel("Bits:"), c);
        c.gridx = 1;
        groupcontent.add(new JComboBox<String>(new String[]{"16", "24"}), c);
        c.gridy = 0;
        c.gridx = 2;
        c.gridheight = 4;
        c.fill = 1;
        JPanel sep = new JPanel();
        sep.setMinimumSize(new Dimension(10, 10));
        sep.setPreferredSize(new Dimension(10, 10));
        sep.setMaximumSize(new Dimension(10, 10));
        groupcontent.add((Component)sep, c);
        c.fill = 0;
        c.gridheight = 1;
        c.gridy = 0;
        c.gridx = 3;
        groupcontent.add((Component)new JButton("Stop"), c);
        c.gridy = 1;
        c.gridx = 3;
        groupcontent.add((Component)new JLabel("Buffer Size:"), c);
        c.gridx = 4;
        groupcontent.add((Component)new JTextField("100"), c);
        c.gridx = 5;
        groupcontent.add((Component)new JLabel("msec"), c);
        c.gridy = 2;
        c.gridx = 3;
        groupcontent.add((Component)new JLabel("Underrun Tolerance:"), c);
        c.gridx = 4;
        groupcontent.add((Component)new JSpinner(), c);
        c.gridy = 3;
        c.gridx = 3;
        groupcontent.add((Component)new JLabel("Priority:"), c);
        c.gridx = 4;
        groupcontent.add((Component)new JSpinner(), c);
        c.gridy = 4;
        c.gridx = 0;
        c.fill = 1;
        c.gridwidth = 0;
        c.insets = new Insets(7, 2, 2, 2);
        JSeparator sep2 = new JSeparator(0);
        sep.setMinimumSize(new Dimension(5, 5));
        sep.setPreferredSize(new Dimension(5, 5));
        groupcontent.add((Component)sep2, c);
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 0;
        c.gridwidth = 1;
        c.gridy = 5;
        c.gridx = 0;
        groupcontent.add((Component)new JLabel("Output Latency (samples)"), c);
        c.gridx = 1;
        groupcontent.add((Component)new JSpinner(), c);
        c.gridx = 3;
        groupcontent.add((Component)new JButton("Measure latency..."), c);
        c.gridy = 6;
        c.gridx = 0;
        c.fill = 1;
        c.gridwidth = 0;
        c.insets = new Insets(7, 2, 2, 2);
        sep2 = new JSeparator(0);
        sep.setMinimumSize(new Dimension(5, 5));
        sep.setPreferredSize(new Dimension(5, 5));
        groupcontent.add((Component)sep2, c);
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 0;
        c.gridy = 7;
        groupcontent.add((Component)new JCheckBox("Use Direct Monitoring"), c);
        c.gridy = 8;
        groupcontent.add((Component)new JCheckBox("Use Multiplexed Javasound Server (Requires Restart)"), c);
        c.gridy = 9;
        groupcontent.add((Component)new JCheckBox("Autoconnect Jack (Requires Restart)"), c);
        JPanel midigroup = new JPanel();
        midigroup.setBorder(BorderFactory.createTitledBorder("MIDI"));
        midigroup.setLayout(new FlowLayout(0, 0, 0));
        groupcontent = new JPanel();
        midigroup.add(groupcontent);
        groupcontent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        groupcontent.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.anchor = 18;
        c.gridwidth = 0;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridwidth = 1;
        groupcontent.add((Component)new JLabel("Input Devices :"), c);
        c.gridwidth = 0;
        String[] midiindevs = new String[]{"Virtual Keyboard", "MIDI Port 1"};
        JList<String> midiindev_list = new JList<String>(midiindevs);
        JScrollPane midiindev_list_s = new JScrollPane(midiindev_list);
        Dimension p = midiindev_list_s.getPreferredSize();
        p.height = 70;
        p.width = 200;
        midiindev_list_s.setPreferredSize(p);
        groupcontent.add((Component)midiindev_list_s, c);
        JPanel midiindev_butonpanel = new JPanel();
        midiindev_butonpanel.setLayout(new FlowLayout(0, 5, 0));
        midiindev_butonpanel.add(new JButton("Add"));
        midiindev_butonpanel.add(new JButton("Remove"));
        c.gridx = 1;
        groupcontent.add((Component)midiindev_butonpanel, c);
        JPanel miscgroup = new JPanel();
        miscgroup.setBorder(BorderFactory.createTitledBorder("User Interface"));
        miscgroup.setLayout(new FlowLayout(0, 0, 0));
        groupcontent = new JPanel();
        miscgroup.add(groupcontent);
        groupcontent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        groupcontent.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridwidth = 0;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridwidth = 1;
        groupcontent.add((Component)new JLabel("Redraw Rate (jumps):"), c);
        c.gridwidth = 0;
        String[] guivalues = new String[]{"Disable when playing", "1"};
        groupcontent.add(new JComboBox<String>(guivalues), c);
        JPanel grouppane = new JPanel();
        grouppane.setLayout(new BoxLayout(grouppane, 1));
        grouppane.add(audiogroup);
        grouppane.add(midigroup);
        grouppane.add(miscgroup);
        contentpane.add(grouppane);
        JPanel buttonpane = new JPanel();
        buttonpane.setLayout(new FlowLayout(2, 5, 5));
        buttonpane.add(new JButton("OK"));
        buttonpane.add(new JButton("Cancel"));
        buttonpane.add(new JButton("Apply"));
        contentpane.add((Component)buttonpane, "South");
        this.setContentPane(contentpane);
        this.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
        if (gc == null) {
            gc = this.getGraphicsConfiguration();
        }
        Rectangle windowSize = gc != null ? gc.getBounds() : new Rectangle(toolkit.getScreenSize());
        Dimension size = this.getSize();
        Point parent_loc = this.getLocation();
        this.setLocation(parent_loc.x + windowSize.width / 2 - size.width / 2, parent_loc.y + windowSize.height / 2 - size.height / 2);
    }
}

