/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth;

import com.frinika.audio.VoiceInterrupt;
import com.frinika.audio.VoiceServer;
import com.frinika.synth.InstrumentNameListener;
import com.frinika.synth.MasterVoice;
import com.frinika.synth.Oscillator;
import com.frinika.synth.PostOscillator;
import com.frinika.synth.PreOscillator;
import com.frinika.synth.SynthRack;
import com.frinika.synth.envelope.MidiVolume;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;
import javax.sound.midi.MidiChannel;

public abstract class Synth
implements MidiChannel {
    protected boolean sustain = false;
    protected HashMap<Integer, Oscillator> keys = new HashMap();
    protected HashMap<Integer, Oscillator> sustainedKeys = new HashMap();
    protected LinkedList<Oscillator> oscillators = new LinkedList();
    protected PreOscillator preOscillator;
    protected PostOscillator postOscillator;
    private String instrumentName = "New Synth";
    private Vector<InstrumentNameListener> instrumentNameListeners = new Vector();
    private boolean mute;
    SynthRack frinikaSynth;

    public Synth(SynthRack synth) {
        this.frinikaSynth = synth;
        this.preOscillator = new PreOscillator(this);
        this.postOscillator = new PostOscillator(this);
        this.preOscillator.nextVoice = this.postOscillator;
        this.postOscillator.nextVoice = MasterVoice.getDefaultInstance();
        synth.getVoiceServer().addTransmitter(this.postOscillator);
        synth.getVoiceServer().addTransmitter(this.preOscillator);
    }

    protected synchronized void addOscillator(int noteNumber, Oscillator osc) {
        try {
            if (this.sustain) {
                this.sustainedKeys.get(new Integer(noteNumber)).release();
                this.sustainedKeys.remove(new Integer(noteNumber));
            } else {
                this.keys.get(new Integer(noteNumber)).release();
                this.keys.remove(new Integer(noteNumber));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        osc.nextVoice = this.postOscillator;
        this.frinikaSynth.getVoiceServer().addTransmitter(osc);
        this.keys.put(new Integer(noteNumber), osc);
        this.oscillators.add(osc);
    }

    public void noteOff(int noteNumber, int velocity) {
        this.noteOff(noteNumber);
    }

    public synchronized void noteOff(int noteNumber) {
        if (this.sustain) {
            this.sustainedKeys.put(new Integer(noteNumber), this.keys.get(new Integer(noteNumber)));
        } else {
            Oscillator voice = this.keys.get(new Integer(noteNumber));
            if (voice != null) {
                voice.release();
            }
        }
        this.keys.remove(new Integer(noteNumber));
    }

    public abstract void loadSettings(Serializable var1);

    public abstract Serializable getSettings();

    public void setPolyPressure(int noteNumber, int pressure) {
    }

    public int getPolyPressure(int noteNumber) {
        return 0;
    }

    public void setChannelPressure(int pressure) {
    }

    public int getChannelPressure() {
        return 0;
    }

    public void controlChange(int controller, final int value) {
        switch (controller) {
            case 1: {
                this.preOscillator.setVibratoAmount(value);
                break;
            }
            case 2: {
                this.preOscillator.setVibratoFrequency(value);
                break;
            }
            case 10: {
                this.getAudioOutput().interruptTransmitter(this.postOscillator, new VoiceInterrupt(){

                    public void doInterrupt() {
                        Synth.this.postOscillator.setPan(value);
                    }
                });
                break;
            }
            case 7: {
                this.getAudioOutput().interruptTransmitter(this.postOscillator, new VoiceInterrupt(){

                    public void doInterrupt() {
                        Synth.this.postOscillator.setVolume(MidiVolume.midiVolumeToAmplitudeRatio(value));
                    }
                });
                break;
            }
            case 20: {
                this.getAudioOutput().interruptTransmitter(this.postOscillator, new VoiceInterrupt(){

                    public void doInterrupt() {
                        Synth.this.postOscillator.setOverDriveAmount(value);
                    }
                });
                break;
            }
            case 22: {
                this.getAudioOutput().interruptTransmitter(this.postOscillator, new VoiceInterrupt(){

                    public void doInterrupt() {
                        Synth.this.postOscillator.setEchoAmount(value);
                    }
                });
                break;
            }
            case 23: {
                this.getAudioOutput().interruptTransmitter(this.postOscillator, new VoiceInterrupt(){

                    public void doInterrupt() {
                        Synth.this.postOscillator.setEchoLength(value);
                    }
                });
                break;
            }
            case 64: {
                if (value > 63) {
                    this.enableSustain();
                    break;
                }
                this.disableSustain();
                break;
            }
            case 91: {
                this.getAudioOutput().interruptTransmitter(this.postOscillator, new VoiceInterrupt(){

                    public void doInterrupt() {
                        Synth.this.postOscillator.setReverb(MidiVolume.midiVolumeToAmplitudeRatio(value));
                    }
                });
            }
        }
    }

    void enableSustain() {
        this.getAudioOutput().interruptTransmitter(this.preOscillator, new VoiceInterrupt(){

            public void doInterrupt() {
                Synth.this.sustain = true;
            }
        });
    }

    synchronized void disableSustain() {
        this.sustain = false;
        for (Oscillator osc : this.oscillators) {
            if (this.keys.containsValue(osc)) continue;
            osc.release();
        }
    }

    public int getController(int controller) {
        return 0;
    }

    public void programChange(int program) {
    }

    public void programChange(int bank, int program) {
    }

    public int getProgram() {
        return 0;
    }

    public void setPitchBend(final int bend) {
        this.getAudioOutput().interruptTransmitter(this.preOscillator, new VoiceInterrupt(){

            public void doInterrupt() {
                Synth.this.preOscillator.pitchBend = bend;
                Synth.this.preOscillator.pitchBendFactor = (float)Math.pow(2.0, (double)(bend - 8192) / 4096.0 / 12.0);
            }
        });
    }

    public int getPitchBend() {
        return this.preOscillator.pitchBend;
    }

    public void resetAllControllers() {
    }

    public void allNotesOff() {
        for (Oscillator osc : this.oscillators) {
            osc.release();
        }
    }

    public void allSoundOff() {
        for (Oscillator osc : this.oscillators) {
            this.frinikaSynth.getVoiceServer().removeTransmitter(osc);
        }
        this.frinikaSynth.getVoiceServer().removeTransmitter(this.postOscillator);
        this.frinikaSynth.getVoiceServer().removeTransmitter(this.preOscillator);
    }

    public boolean localControl(boolean on) {
        return false;
    }

    public void setMono(boolean on) {
    }

    public boolean getMono() {
        return false;
    }

    public void setOmni(boolean on) {
    }

    public boolean getOmni() {
        return false;
    }

    public void setMute(boolean mute) {
        this.mute = mute;
    }

    public boolean getMute() {
        return this.mute;
    }

    public void setSolo(boolean soloState) {
    }

    public boolean getSolo() {
        return false;
    }

    public VoiceServer getAudioOutput() {
        return this.frinikaSynth.getVoiceServer();
    }

    public void close() {
        this.allSoundOff();
    }

    public void showGUI() {
        System.out.println("Sorry, no GUI...");
    }

    public String getInstrumentName() {
        return this.instrumentName;
    }

    public void setInstrumentName(String instrumentName) {
        this.instrumentName = instrumentName;
        for (InstrumentNameListener instrumentNameListener : this.instrumentNameListeners) {
            instrumentNameListener.instrumentNameChange(this, instrumentName);
        }
    }

    public void addInstrumentNameListener(InstrumentNameListener instrumentNameListener) {
        this.instrumentNameListeners.add(instrumentNameListener);
    }

    public void removeInstrumentNameListener(InstrumentNameListener instrumentNameListener) {
        this.instrumentNameListeners.remove(instrumentNameListener);
    }

    public final PostOscillator getPostOscillator() {
        return this.postOscillator;
    }

    public final PreOscillator getPreOscillator() {
        return this.preOscillator;
    }

    public SynthRack getFrinikaSynth() {
        return this.frinikaSynth;
    }

    public String toString() {
        return this.getInstrumentName();
    }
}

