/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth;

import com.frinika.contrib.boblang.FrinikaBezierSynth;
import com.frinika.synth.InstrumentNameListener;
import com.frinika.synth.Synth;
import com.frinika.synth.SynthRack;
import com.frinika.synth.synths.Analogika;
import com.frinika.synth.synths.MySampler;
import com.frinika.synth.synths.Organ;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.LineBorder;

public class SynthMixerSlot
implements InstrumentNameListener {
    private static final long serialVersionUID = 1L;
    JComboBox synthCB;
    JSlider volSlider;
    JSlider panSlider;
    JLabel instrumentName = new JLabel(" ");
    final SynthRegister synthRegister = new SynthRegister();
    int synthNo;
    SynthRack ms;

    public SynthMixerSlot(JPanel synthListPanel, GridBagConstraints gc, SynthRack ms, int synthNo) {
        this.ms = ms;
        this.synthNo = synthNo;
        gc.fill = 2;
        gc.gridwidth = -1;
        gc.anchor = 17;
        synthListPanel.add((Component)new JLabel("Program " + synthNo), gc);
        synthListPanel.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.synthCB = new JComboBox();
        this.synthCB.addItem("");
        for (SynthRegisterEntry synthEntry : this.synthRegister.values()) {
            this.synthCB.addItem(synthEntry);
        }
        this.synthCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    try {
                        SynthMixerSlot.this.ms.setSynth(SynthMixerSlot.this.synthNo, (Synth)((SynthRegisterEntry)e.getItem()).synthClass.getConstructors()[0].newInstance(SynthMixerSlot.this.ms));
                    }
                    catch (Exception ex) {
                        SynthMixerSlot.this.ms.setSynth(SynthMixerSlot.this.synthNo, null);
                    }
                }
            }
        });
        if (ms.getSynth(synthNo) != null) {
            this.instrumentName.setText(ms.getSynth(synthNo).getInstrumentName());
        }
        synthListPanel.add((Component)this.instrumentName, gc);
        synthListPanel.add((Component)this.synthCB, gc);
        JButton showSynthGUIButton = new JButton("Edit");
        showSynthGUIButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (SynthMixerSlot.this.ms.synths[SynthMixerSlot.this.synthNo] != null) {
                    SynthMixerSlot.this.ms.synths[SynthMixerSlot.this.synthNo].showGUI();
                }
            }
        });
        gc.gridwidth = 0;
        synthListPanel.add((Component)showSynthGUIButton, gc);
        if (ms.getSynth(synthNo) != null) {
            this.setSynth(ms.getSynth(synthNo));
        }
    }

    public void setSynth(Synth synth) {
        ItemListener listener = this.synthCB.getItemListeners()[0];
        this.synthCB.removeItemListener(listener);
        if (synth != null) {
            this.synthCB.setSelectedItem(this.synthRegister.get(synth.getClass()));
            synth.addInstrumentNameListener(this);
        } else {
            this.synthCB.setSelectedIndex(0);
        }
        this.synthCB.addItemListener(listener);
    }

    public void setVolume(int volume) {
        this.volSlider.setValue(volume);
    }

    public void setPan(int pan) {
        this.panSlider.setValue(pan);
    }

    public void instrumentNameChange(Synth synth, String instrumentName) {
        this.instrumentName.setText(instrumentName + " ");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SynthRegister
    extends HashMap<Class, SynthRegisterEntry> {
        private static final long serialVersionUID = 1L;

        public SynthRegister() {
            this.put(Organ.class, new SynthRegisterEntry(Organ.class, "Organ"));
            this.put(Analogika.class, new SynthRegisterEntry(Analogika.class, "Analogika"));
            this.put(MySampler.class, new SynthRegisterEntry(MySampler.class, "mySampler"));
            this.put(FrinikaBezierSynth.class, new SynthRegisterEntry(FrinikaBezierSynth.class, "BezierSynth"));
        }
    }

    final class SynthRegisterEntry {
        Class synthClass;
        String synthName;

        public SynthRegisterEntry(Class synthClass, String synthName) {
            this.synthClass = synthClass;
            this.synthName = synthName;
        }

        public String toString() {
            return this.synthName;
        }
    }
}

