/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth;

import com.frinika.audio.VoiceServer;
import com.frinika.sequencer.ChannelListProvider;
import com.frinika.sequencer.gui.mixer.MidiDeviceIconProvider;
import com.frinika.sequencer.midi.MidiListProvider;
import com.frinika.sequencer.model.ControllerListProvider;
import com.frinika.sequencer.model.FrinikaControllerList;
import com.frinika.synth.GlobalInstrumentNameListener;
import com.frinika.synth.InstrumentNameListener;
import com.frinika.synth.MasterVoice;
import com.frinika.synth.Synth;
import com.frinika.synth.SynthRackGUI;
import com.frinika.synth.settings.SynthSettings;
import com.frinika.synth.settings.synthsettingsversions.SynthSettings20070815;
import com.frinika.synth.soundbank.SynthRackSoundbank;
import com.frinika.synth.synths.MySampler;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.sound.midi.Instrument;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.VoiceStatus;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import rasmus.midi.provider.RasmusSynthesizer;

public class SynthRack
implements Synthesizer,
InstrumentNameListener,
MidiListProvider,
ChannelListProvider,
MidiDeviceIconProvider,
Mixer {
    public static final double GAIN = 0.5;
    VoiceServer voiceServer;
    private static Icon icon = new ImageIcon(RasmusSynthesizer.class.getResource("/icons/frinika.png"));
    private static FrinikaControllerList controllerList = new FrinikaControllerList();
    boolean saveReferencedData;
    MidiDevice.Info deviceInfo = new SynthRackInfo();
    Receiver receiver = new Receiver(){

        public void send(MidiMessage message, long timeStamp) {
            try {
                byte[] msgBytes;
                if (ShortMessage.class.isInstance(message)) {
                    ShortMessage shm = (ShortMessage)message;
                    int synthIndex = shm.getChannel();
                    MidiChannel channel = SynthRack.this.midiChannels[shm.getChannel()];
                    if (channel != null) {
                        if (shm.getCommand() == 144) {
                            if (shm.getData2() == 0) {
                                channel.noteOff(shm.getData1());
                            } else if (!channel.getMute()) {
                                channel.noteOn(shm.getData1(), shm.getData2());
                            }
                        } else if (shm.getCommand() == 128) {
                            channel.noteOff(shm.getData1());
                        } else if (shm.getCommand() == 176) {
                            channel.controlChange(shm.getData1(), shm.getData2());
                            if (SynthRack.this.gui != null && shm.getData1() == 7) {
                                SynthRack.this.gui.synthStrips[synthIndex].setVolume(shm.getData2());
                            } else if (SynthRack.this.gui != null && shm.getData1() == 10) {
                                SynthRack.this.gui.synthStrips[synthIndex].setPan(shm.getData2());
                            }
                        } else if (shm.getCommand() == 224) {
                            channel.setPitchBend((0xFF & shm.getData1()) + ((0xFF & shm.getData2()) << 7));
                        }
                    }
                    if (shm.getCommand() == 192) {
                        SynthRack.this.midiChannels[shm.getChannel()] = SynthRack.this.synths[shm.getData1()];
                    }
                } else if (MetaMessage.class.isInstance(message) && (msgBytes = message.getMessage())[0] == -1 && msgBytes[1] == 81 && msgBytes[2] == 3) {
                    int mpq = (msgBytes[3] & 0xFF) << 16 | (msgBytes[4] & 0xFF) << 8 | msgBytes[5] & 0xFF;
                    SynthRack.this.tempoBPM = 6.0E7f / (float)mpq;
                    Logger.getLogger(this.getClass().getName()).fine("Tempo set to " + SynthRack.this.tempoBPM + " bpm");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        public void close() {
        }
    };
    List<Receiver> receivers = new ArrayList<Receiver>();
    List<Transmitter> transmitters;
    SynthRackGUI gui;
    Synth[] synths;
    MidiChannel[] midiChannels;
    private Vector<GlobalInstrumentNameListener> globalInstrumentNameListeners;
    private SynthRackSoundbank soundbank;
    private float tempoBPM;

    public Icon getIcon() {
        if (icon.getIconHeight() > 16 || icon.getIconWidth() > 16) {
            BufferedImage img = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 6);
            Graphics2D g = img.createGraphics();
            icon.paintIcon(null, g, 0, 0);
            g.dispose();
            Image im = img.getScaledInstance(16, 16, 4);
            icon = new ImageIcon(im);
        }
        return icon;
    }

    public SynthRack(VoiceServer voiceServer) {
        this.receivers.add(this.receiver);
        this.transmitters = new ArrayList<Transmitter>();
        this.synths = new Synth[256];
        this.midiChannels = new MidiChannel[16];
        this.globalInstrumentNameListeners = new Vector();
        this.soundbank = new SynthRackSoundbank();
        this.tempoBPM = 100.0f;
        this.voiceServer = voiceServer;
        if (voiceServer != null) {
            MasterVoice.getDefaultInstance().initialize(voiceServer);
        }
    }

    public void setSynth(int index, Synth synth) {
        if (this.synths[index] != null) {
            this.synths[index].close();
        }
        if (synth != null) {
            synth.addInstrumentNameListener(this);
            Patch patch = new Patch(0, index);
            this.soundbank.createAndRegisterInstrument(patch, synth);
        }
        this.synths[index] = synth;
        if (this.gui != null) {
            this.gui.synthStrips[index].setSynth(synth);
        }
    }

    public Synth getSynth(int index) {
        return this.synths[index];
    }

    public SynthSettings getSynthSetup() {
        SynthSettings20070815 setup = new SynthSettings20070815();
        String[] synthClassNames = setup.getSynthClassNames();
        Serializable[] synthSettings = setup.getSynthSettings();
        for (int n = 0; n < this.synths.length; ++n) {
            try {
                synthClassNames[n] = this.synths[n].getClass().getName();
                synthSettings[n] = this.synths[n].getSettings();
                continue;
            }
            catch (NullPointerException nex) {
                // empty catch block
            }
        }
        return setup;
    }

    public void clearSynths() {
        for (int n = 0; n < this.synths.length; ++n) {
            try {
                this.setSynth(n, null);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void loadSynthSetup(final SynthSettings setup) {
        if (this.gui != null) {
            this.gui.initLoadSynthSetupProgress(new Thread(){

                public void run() {
                    SynthRack.this.loadSynthSetupThread(setup);
                }
            });
        } else {
            this.loadSynthSetupThread(setup);
        }
    }

    public void loadSynthSetupThread(SynthSettings setup) {
        if (this.voiceServer == null) {
            this.setVoiceServer(new VoiceServer(){

                public void configureAudioOutput(JFrame frame) {
                }
            });
        }
        this.clearSynths();
        for (int n = 0; n < setup.getSynthClassNames().length; ++n) {
            try {
                String synthName = setup.getSynthClassNames()[n];
                if (synthName == null) break;
                if (synthName.equals("com.petersalomonsen.mystudio.mysynth.synths.SoundFont") || synthName.equals("com.petersalomonsen.mystudio.mysynth.synths.MySampler")) {
                    synthName = MySampler.class.getName();
                }
                this.setSynth(n, (Synth)Class.forName(synthName).getConstructors()[0].newInstance(this));
                this.synths[n].loadSettings(setup.getSynthSettings()[n]);
                if (this.gui == null) continue;
                this.gui.notifyLoadSynthSetupProgress(n * 100 / setup.getSynthClassNames().length, this.synths[n].getInstrumentName());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.gui != null) {
            this.gui.notifyLoadSynthSetupProgress(100, "Completed");
        }
    }

    public void save(File file) {
        try {
            SynthSettings setup = this.getSynthSetup();
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
            out.writeObject(setup);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load(File file) {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
            SynthSettings setup = (SynthSettings)in.readObject();
            this.loadSynthSetup(setup);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getMaxPolyphony() {
        return 0;
    }

    public long getLatency() {
        return this.voiceServer.getLatency();
    }

    public MidiChannel[] getChannels() {
        return null;
    }

    public VoiceStatus[] getVoiceStatus() {
        return null;
    }

    public boolean isSoundbankSupported(Soundbank soundbank) {
        return false;
    }

    public boolean loadInstrument(Instrument instrument) {
        return false;
    }

    public void unloadInstrument(Instrument instrument) {
    }

    public boolean remapInstrument(Instrument from, Instrument to) {
        return false;
    }

    public Soundbank getDefaultSoundbank() {
        return null;
    }

    public Instrument[] getAvailableInstruments() {
        return new Instrument[0];
    }

    public Instrument[] getLoadedInstruments() {
        return this.soundbank.getInstruments();
    }

    public boolean loadAllInstruments(Soundbank soundbank) {
        return false;
    }

    public void unloadAllInstruments(Soundbank soundbank) {
    }

    public boolean loadInstruments(Soundbank soundbank, Patch[] patchList) {
        return false;
    }

    public void unloadInstruments(Soundbank soundbank, Patch[] patchList) {
    }

    public MidiDevice.Info getDeviceInfo() {
        return this.deviceInfo;
    }

    public void open() {
    }

    public void close() {
    }

    public boolean isOpen() {
        return false;
    }

    public long getMicrosecondPosition() {
        return 0L;
    }

    public int getMaxReceivers() {
        return -1;
    }

    public int getMaxTransmitters() {
        return 0;
    }

    public Receiver getReceiver() throws MidiUnavailableException {
        return this.receiver;
    }

    public List getReceivers() {
        return this.receivers;
    }

    public Transmitter getTransmitter() throws MidiUnavailableException {
        return null;
    }

    public List getTransmitters() {
        return this.transmitters;
    }

    public void addGlobalInstrumentNameListener(GlobalInstrumentNameListener globalInstrumentNameListener) {
        this.globalInstrumentNameListeners.add(globalInstrumentNameListener);
    }

    public void instrumentNameChange(Synth synth, String instrumentName) {
        for (int n = 0; n < this.synths.length; ++n) {
            if (!synth.equals(this.synths[n])) continue;
            for (GlobalInstrumentNameListener globalInstrumentNameListener : this.globalInstrumentNameListeners) {
                globalInstrumentNameListener.instrumentNameChange(n, instrumentName);
            }
        }
    }

    public int getNumberOfSynths() {
        return this.synths.length;
    }

    public VoiceServer getVoiceServer() {
        return this.voiceServer;
    }

    public String toString() {
        return this.getDeviceInfo().toString();
    }

    public Object[] getList() {
        return this.synths;
    }

    public boolean isSaveReferencedData() {
        return this.saveReferencedData;
    }

    public void setSaveReferencedData(boolean saveReferencedData) {
        this.saveReferencedData = saveReferencedData;
    }

    public ControllerListProvider getControllerList() {
        return controllerList;
    }

    public void setVoiceServer(VoiceServer voiceServer) {
        this.voiceServer = voiceServer;
        if (voiceServer != null) {
            MasterVoice.getDefaultInstance().initialize(voiceServer);
        }
    }

    public Line getLine(Line.Info info) throws LineUnavailableException {
        return new TargetDataLine(){
            ByteBuffer buf = null;
            float[] floatBuffer = null;
            FloatBuffer flView = null;

            public void open(AudioFormat format) throws LineUnavailableException {
            }

            public void open(AudioFormat format, int bufferSize) throws LineUnavailableException {
            }

            public int read(byte[] b, int off, int len) {
                if (this.buf == null || this.buf.capacity() != len) {
                    this.buf = ByteBuffer.allocate(b.length).order(ByteOrder.nativeOrder());
                    this.flView = this.buf.asFloatBuffer();
                    this.floatBuffer = new float[this.flView.capacity()];
                }
                for (int n = 0; n < this.floatBuffer.length; ++n) {
                    this.floatBuffer[n] = 0.0f;
                }
                SynthRack.this.voiceServer.read(this.floatBuffer);
                this.flView.position(0);
                this.flView.put(this.floatBuffer);
                this.buf.position(0);
                this.buf.get(b);
                return len;
            }

            public int available() {
                return 0;
            }

            public void drain() {
            }

            public void flush() {
            }

            public int getBufferSize() {
                return 0;
            }

            public AudioFormat getFormat() {
                return null;
            }

            public int getFramePosition() {
                return 0;
            }

            public float getLevel() {
                return 0.0f;
            }

            public long getLongFramePosition() {
                return 0L;
            }

            public long getMicrosecondPosition() {
                return 0L;
            }

            public boolean isActive() {
                return false;
            }

            public boolean isRunning() {
                return false;
            }

            public void start() {
            }

            public void stop() {
            }

            public void addLineListener(LineListener listener) {
            }

            public void close() {
            }

            public Control getControl(Control.Type control) {
                return null;
            }

            public Control[] getControls() {
                return null;
            }

            public Line.Info getLineInfo() {
                return null;
            }

            public boolean isControlSupported(Control.Type control) {
                return false;
            }

            public boolean isOpen() {
                return false;
            }

            public void open() throws LineUnavailableException {
            }

            public void removeLineListener(LineListener listener) {
            }
        };
    }

    public int getMaxLines(Line.Info info) {
        return 0;
    }

    public Mixer.Info getMixerInfo() {
        return null;
    }

    public Line.Info[] getSourceLineInfo() {
        return null;
    }

    public Line.Info[] getSourceLineInfo(Line.Info info) {
        return null;
    }

    public Line[] getSourceLines() {
        return null;
    }

    public Line.Info[] getTargetLineInfo() {
        return null;
    }

    public Line.Info[] getTargetLineInfo(Line.Info info) {
        return null;
    }

    public Line[] getTargetLines() {
        return null;
    }

    public boolean isLineSupported(Line.Info info) {
        return false;
    }

    public boolean isSynchronizationSupported(Line[] lines, boolean maintainSync) {
        return false;
    }

    public void synchronize(Line[] lines, boolean maintainSync) {
    }

    public void unsynchronize(Line[] lines) {
    }

    public void addLineListener(LineListener listener) {
    }

    public Control getControl(Control.Type control) {
        return null;
    }

    public Control[] getControls() {
        return null;
    }

    public Line.Info getLineInfo() {
        return null;
    }

    public boolean isControlSupported(Control.Type control) {
        return false;
    }

    public void removeLineListener(LineListener listener) {
    }

    public float getTempoBPM() {
        return this.tempoBPM;
    }

    public void show() {
        JFrame f = new JFrame();
        JScrollPane s = new JScrollPane(20, 30);
        if (this.gui == null) {
            this.gui = new SynthRackGUI(f, this);
        }
        f.add(s);
        f.setVisible(true);
        f.setSize(600, 400);
        s.getViewport().add(this.gui);
    }

    public static void main(String[] args) throws Exception {
        MidiDevice.Info info = null;
        for (MidiDevice.Info inf : MidiSystem.getMidiDeviceInfo()) {
            if (!inf.getClass().equals(SynthRackInfo.class)) continue;
            info = inf;
        }
        SynthRack s = (SynthRack)MidiSystem.getMidiDevice(info);
        s.show();
        s.gui.frame.setDefaultCloseOperation(3);
    }

    public static class SynthRackInfo
    extends MidiDevice.Info {
        SynthRackInfo() {
            super("Frinika SynthRack", "petersalomonsen.com", "A MIDI container for Frinika soft synths", "0.4.0");
        }
    }
}

