/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth;

import com.frinika.synth.SynthMixerSlot;
import com.frinika.synth.SynthRack;
import com.frinika.tracker.filedialogs.OpenGearDialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class SynthRackGUI
extends JPanel {
    private static final long serialVersionUID = 1L;
    SynthRack ms;
    SynthMixerSlot[] synthStrips;
    OpenGearDialog openGearDialog = null;
    JFrame frame;

    public SynthRackGUI(JFrame frame, SynthRack ms) {
        this.frame = frame;
        this.ms = ms;
        ms.gui = this;
        this.synthStrips = new SynthMixerSlot[ms.synths.length];
        this.initialize();
        frame.setTitle("Frinika SynthRack - Legacy Frinika soft synths by Peter Salomonsen");
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        for (int n = 0; n < this.synthStrips.length; ++n) {
            this.synthStrips[n] = new SynthMixerSlot(this, gc, this.ms, n);
        }
    }

    public void initLoadSynthSetupProgress(Thread loadingThread) {
        this.openGearDialog = new OpenGearDialog(this.frame);
        loadingThread.start();
        this.openGearDialog.setProgress(0, "");
        this.openGearDialog.setVisible(true);
    }

    public void notifyLoadSynthSetupProgress(int progress, String synthName) {
        this.openGearDialog.setProgress(progress, synthName);
        if (progress == 100) {
            this.openGearDialog = null;
        }
    }

    public static void main(String[] args) throws Exception {
        SynthRack.main(args);
    }
}

