/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth.filters;

import java.awt.Graphics;
import javax.swing.JFrame;

public final class HiPass {
    float previousSample = 0.0f;
    float cutOff = 0.1f;
    float dcLevel = 0.0f;

    public final void setCutOff(float cutOff) {
        this.cutOff = cutOff;
    }

    public final float filter(float sample) {
        float newSample = sample - this.dcLevel;
        this.dcLevel = newSample > this.cutOff ? (this.dcLevel += this.cutOff) : (newSample < -this.cutOff ? (this.dcLevel -= this.cutOff) : sample);
        return newSample;
    }

    public static void main(String[] args) {
        final HiPass hiPass = new HiPass();
        hiPass.setCutOff(0.001f);
        final JFrame frame = new JFrame(){

            public void paint(Graphics g) {
                g.clearRect(0, 0, 600, 600);
                int prevX = 0;
                int prevY = 300;
                float n = 0.0f;
                while ((double)n < Math.PI * 2) {
                    float w1 = (float)Math.sin(n) * 2.0f;
                    float w2 = (float)Math.sin(n * 32.0f) / 4.0f;
                    float w = hiPass.filter(w1 + w2);
                    int x = (int)((double)n / (Math.PI * 2) * 600.0);
                    int y = (int)(w * 100.0f + 300.0f);
                    System.out.println(x + " " + y + " " + hiPass.cutOff);
                    g.drawLine(prevX, prevY, x, y);
                    prevX = x;
                    prevY = y;
                    n = (float)((double)n + 0.01);
                }
            }
        };
        frame.setVisible(true);
        frame.setSize(600, 600);
        frame.setDefaultCloseOperation(3);
        new Thread(){

            public void run() {
                float cutOff = 0.0f;
                while (cutOff < 0.5f) {
                    frame.repaint();
                    cutOff = (float)((double)cutOff + 5.0E-4);
                    hiPass.setCutOff(cutOff);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {}
                }
            }
        }.start();
    }
}

