/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth.importers.soundfont;

import com.frinika.synth.importers.soundfont.Chunk;
import com.frinika.synth.importers.soundfont.IBAGChunk;
import com.frinika.synth.importers.soundfont.IGENChunk;
import com.frinika.synth.importers.soundfont.IMODChunk;
import com.frinika.synth.importers.soundfont.INSTChunk;
import com.frinika.synth.importers.soundfont.PHDRChunk;
import com.frinika.synth.importers.soundfont.SHDRChunk;
import com.frinika.synth.importers.soundfont.SoundFontImporterGUI;
import com.frinika.synth.synths.MySampler;
import com.frinika.synth.synths.sampler.settings.sampledsoundsettingversions.SampledSound20050403;
import java.io.File;
import java.io.FileInputStream;

public class SoundFontImporter {
    FileInputStream fis;
    long size;
    public short globalRelease;
    public File file;
    INSTChunk inst;
    IBAGChunk ibag;
    IGENChunk igen;
    IMODChunk imod;
    SHDRChunk shdr;
    Chunk chSmpl;
    int instrumentIndex;
    MySampler sampler;

    public SoundFontImporter(MySampler sampler) {
        this.sampler = sampler;
    }

    public void getSoundFont(File file) throws Exception {
        this.file = file;
        this.fis = new FileInputStream(file);
        this.chSmpl = new Chunk(this.fis, "smpl");
        this.fis.skip(this.chSmpl.length);
        new PHDRChunk(this.fis);
        this.inst = new INSTChunk(this.fis);
        this.ibag = new IBAGChunk(this.fis);
        this.imod = new IMODChunk(this.fis);
        this.igen = new IGENChunk(this.fis);
        this.shdr = new SHDRChunk(this.fis);
        this.fis.close();
    }

    public String[] getInstrumentNames() {
        return this.inst.names;
    }

    public void getInstrument(int InstrNo) throws Exception {
        this.instrumentIndex = InstrNo;
        this.sampler.setInstrumentName(this.inst.names[InstrNo]);
        int ibagIndex = this.inst.instBagNdx[InstrNo];
        int nextIbagIndex = this.inst.instBagNdx[InstrNo + 1];
        for (int z = ibagIndex; z < nextIbagIndex; ++z) {
            int n;
            int instGenNdx = this.ibag.instGenNdx[z];
            int nextInstGenNdx = this.ibag.instGenNdx[z + 1];
            int hiKey = 199;
            int loKey = 0;
            int hiVel = 127;
            int loVel = 0;
            int rootKey = -1;
            int sampleRate = 0;
            int loopStart = 0;
            int loopEnd = 0;
            int sampleMode = 0;
            short fineTune = 0;
            int scaleTune = 100;
            int exclusiveClass = 0;
            String sampleName = null;
            short[] sampleData = null;
            int sampleType = 0;
            for (n = instGenNdx; n < nextInstGenNdx; ++n) {
                if (this.igen.sfGenOper[n] == 38) {
                    this.globalRelease = (short)this.igen.genAmount[n];
                }
                if (this.igen.sfGenOper[n] == 43) {
                    hiKey = this.igen.genAmount[n] >> 8;
                    loKey = this.igen.genAmount[n] & 0xFF;
                }
                if (this.igen.sfGenOper[n] == 44) {
                    hiVel = this.igen.genAmount[n] >> 8;
                    loVel = this.igen.genAmount[n] & 0xFF;
                }
                if (this.igen.sfGenOper[n] == 56) {
                    scaleTune = this.igen.genAmount[n];
                }
                if (this.igen.sfGenOper[n] == 57) {
                    System.out.println("exclusive: " + this.igen.genAmount[n]);
                    exclusiveClass = this.igen.genAmount[n];
                }
                if (this.igen.sfGenOper[n] == 58) {
                    rootKey = this.igen.genAmount[n];
                }
                if (this.igen.sfGenOper[n] == 54) {
                    sampleMode = this.igen.genAmount[n];
                }
                if (this.igen.sfGenOper[n] == 52) {
                    fineTune = (short)this.igen.genAmount[n];
                }
                if (this.igen.sfGenOper[n] != 53) continue;
                sampleRate = this.shdr.sampleRate[this.igen.genAmount[n]];
                sampleType = this.shdr.sfSampleType[this.igen.genAmount[n]];
                loopStart = this.shdr.sampleStartLoop[this.igen.genAmount[n]] - this.shdr.sampleStart[this.igen.genAmount[n]];
                loopEnd = this.shdr.sampleEndLoop[this.igen.genAmount[n]] - this.shdr.sampleStart[this.igen.genAmount[n]];
                if (rootKey == -1) {
                    rootKey = this.shdr.originalPitch[this.igen.genAmount[n]];
                }
                if (this.shdr.samples[this.igen.genAmount[n]] == null) {
                    FileInputStream fis = new FileInputStream(this.file);
                    this.chSmpl = new Chunk(fis, "smpl");
                    sampleData = new short[this.shdr.sampleEnd[this.igen.genAmount[n]] - this.shdr.sampleStart[this.igen.genAmount[n]]];
                    fis.skip(this.shdr.sampleStart[this.igen.genAmount[n]] * 2);
                    byte[] bSample = new byte[sampleData.length * 2];
                    fis.read(bSample);
                    for (int sCount = 0; sCount < bSample.length; sCount += 2) {
                        sampleData[sCount / 2] = (short)((0xFF & bSample[sCount + 0]) + (0xFF & bSample[sCount + 1]) * 256);
                    }
                    fis.close();
                    this.shdr.samples[this.igen.genAmount[n]] = sampleData;
                } else {
                    sampleData = this.shdr.samples[this.igen.genAmount[n]];
                }
                sampleName = this.shdr.names[this.igen.genAmount[n]];
            }
            if (sampleData == null || sampleType != 1 && sampleType != 2 && sampleType != 4) continue;
            for (n = loKey; n <= hiKey; ++n) {
                for (int v = loVel; v <= hiVel; ++v) {
                    if (this.sampler.sampledSounds[n][v] == null) {
                        this.sampler.insertSample(new SampledSound20050403(), n, v);
                    }
                    if (sampleType == 1) {
                        this.sampler.sampledSounds[n][v].setLeftSamples(sampleData);
                        this.sampler.sampledSounds[n][v].setRightSamples(sampleData);
                    }
                    if (sampleType == 2) {
                        this.sampler.sampledSounds[n][v].setRightSamples(sampleData);
                    }
                    if (sampleType == 4) {
                        this.sampler.sampledSounds[n][v].setLeftSamples(sampleData);
                    }
                    this.sampler.sampledSounds[n][v].setSampleMode(sampleMode);
                    this.sampler.sampledSounds[n][v].setLoopStart(loopStart);
                    this.sampler.sampledSounds[n][v].setLoopEnd(loopEnd);
                    this.sampler.sampledSounds[n][v].setRootKey(rootKey);
                    this.sampler.sampledSounds[n][v].setFineTune(fineTune);
                    this.sampler.sampledSounds[n][v].setScaleTune(scaleTune);
                    this.sampler.sampledSounds[n][v].setSampleRate(sampleRate);
                    this.sampler.sampledSounds[n][v].setRelease(this.globalRelease);
                    this.sampler.sampledSounds[n][v].setSampleName(sampleName);
                    this.sampler.sampledSounds[n][v].setExclusiveClass(exclusiveClass);
                }
            }
        }
    }

    public int getInstrumentIndex() {
        return this.instrumentIndex;
    }

    public void showGUI() {
        new SoundFontImporterGUI(this);
    }
}

