/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth.synths;

import com.frinika.global.FrinikaConfig;
import com.frinika.synth.Oscillator;
import com.frinika.synth.Pan;
import com.frinika.synth.PitchCents;
import com.frinika.synth.Synth;
import com.frinika.synth.SynthRack;
import com.frinika.synth.envelope.VolumeEnvelope;
import com.frinika.synth.importers.soundfont.SoundFontImporter;
import com.frinika.synth.importers.soundfont.SoundFontImporterGUI;
import com.frinika.synth.synths.sampler.SamplerGUI;
import com.frinika.synth.synths.sampler.SamplerOscillator;
import com.frinika.synth.synths.sampler.settings.SampledSoundSettings;
import com.frinika.synth.synths.sampler.settings.SamplerSettings;
import com.frinika.synth.synths.sampler.settings.sampledsoundsettingversions.SampledSound20050403;
import com.frinika.synth.synths.sampler.settings.samplersettingversions.Sampler20050227;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;

public class MySampler
extends Synth {
    protected HashMap<Integer, Vector<SoundFontOscillator>> exclusiveClasses = new HashMap();
    public SoundFontImporter sfi;
    public SamplerOscillator samplerOscillator = new SamplerOscillator(this);
    public SamplerGUI gui;
    public SampledSoundSettings[][] sampledSounds = new SampledSoundSettings[200][128];
    public int recordMode;
    SamplerSettings samplerSettings = new Sampler20050227();
    public static final int RECORDMODE_SINGLE_KEY = 0;
    public static final int RECORDMODE_ALL_KEYS = 1;
    public static final int RECORDMODE_SELECTION = 2;
    public static final int SAMPLEMODE_NO_LOOP = 0;
    public static final int SAMPLEMODE_LOOP_CONTINOUSLY = 1;
    public static final int SAMPLEMODE_LOOP_UNTIL_RELEASE = 3;

    public MySampler(SynthRack synth) {
        super(synth);
        this.sfi = new SoundFontImporter(this);
        this.getAudioOutput().addTransmitter(this.samplerOscillator);
    }

    public SoundFontImporter getImporter() {
        return this.sfi;
    }

    public void insertSample(SampledSoundSettings snd, int noteNumber, int velocity) {
        this.sampledSounds[noteNumber][velocity] = snd;
    }

    public void loadSettings(Serializable settings) {
        block5: {
            try {
                this.samplerSettings = (SamplerSettings)((Object)settings);
                this.setInstrumentName(this.samplerSettings.getInstrumentName());
                if (this.samplerSettings.getSoundFontName() != null) {
                    try {
                        this.sfi.getSoundFont(new File(this.samplerSettings.getSoundFontName()));
                    }
                    catch (FileNotFoundException fne) {
                        SoundFontImporterGUI.getMissingSoundFont(new File(this.samplerSettings.getSoundFontName()), this.sfi);
                    }
                    System.out.println("InstrumentIndex: " + this.samplerSettings.getInstrumentIndex());
                    this.sfi.getInstrument(this.samplerSettings.getInstrumentIndex());
                    break block5;
                }
                this.sampledSounds = this.samplerSettings.getSampledSounds();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Serializable getSettings() {
        Sampler20050227 settings = new Sampler20050227();
        try {
            if (this.getFrinikaSynth().isSaveReferencedData()) {
                throw new Exception("Also saving referenced data");
            }
            settings.setSoundFontName(this.sfi.file.getAbsolutePath());
            settings.setInstrumentIndex(this.sfi.getInstrumentIndex());
            settings.setInstrumentName(this.getInstrumentName());
        }
        catch (Exception e) {
            settings.setInstrumentName(this.getInstrumentName());
            settings.setSampledSounds(this.sampledSounds);
        }
        settings.setFreqSpread(this.samplerSettings.getFreqSpread());
        settings.setLayers(this.samplerSettings.getLayers());
        return settings;
    }

    public SamplerSettings getSamplerSettings() {
        return this.samplerSettings;
    }

    public void close() {
        super.close();
        this.getAudioOutput().removeTransmitter(this.samplerOscillator);
    }

    public synchronized void noteOn(int noteNumber, int velocity) {
        if (this.samplerOscillator.isMonitoring() && !this.samplerOscillator.isRecording()) {
            switch (this.recordMode) {
                case 2: {
                    if (!this.gui.isNoteInSelection(noteNumber, velocity)) break;
                }
                default: {
                    this.samplerOscillator.startRecording();
                    SamplingOscillator osc = new SamplingOscillator(this, noteNumber, velocity);
                    this.addOscillator(noteNumber, osc);
                }
            }
        } else {
            switch (this.samplerSettings.getLayers()) {
                case 2: {
                    SoundFontOscillator osc = new SoundFontOscillator(this, noteNumber, velocity);
                    osc.setNoteNumber(noteNumber, -this.samplerSettings.getFreqSpread(), 0.0f);
                    osc.setVelocity(velocity);
                    this.addOscillator(noteNumber, osc);
                    SoundFontOscillator layerOsc = new SoundFontOscillator(this, noteNumber, velocity);
                    layerOsc.setNoteNumber(noteNumber, this.samplerSettings.getFreqSpread(), 1.0f);
                    layerOsc.setVelocity(velocity);
                    osc.addLayer(layerOsc);
                    break;
                }
                case 3: {
                    SoundFontOscillator osc = new SoundFontOscillator(this, noteNumber, velocity);
                    osc.setNoteNumber(noteNumber, -this.samplerSettings.getFreqSpread(), 0.0f);
                    osc.setVelocity(velocity);
                    this.addOscillator(noteNumber, osc);
                    SoundFontOscillator layerOsc = new SoundFontOscillator(this, noteNumber, velocity);
                    layerOsc.setNoteNumber(noteNumber, 0.0f, 0.5f);
                    layerOsc.setVelocity(velocity);
                    osc.addLayer(layerOsc);
                    layerOsc = new SoundFontOscillator(this, noteNumber, velocity);
                    layerOsc.setNoteNumber(noteNumber, this.samplerSettings.getFreqSpread(), 1.0f);
                    layerOsc.setVelocity(velocity);
                    osc.addLayer(layerOsc);
                    break;
                }
                case 4: {
                    SoundFontOscillator osc = new SoundFontOscillator(this, noteNumber, velocity);
                    osc.setNoteNumber(noteNumber, -this.samplerSettings.getFreqSpread(), 0.0f);
                    osc.setVelocity(velocity);
                    this.addOscillator(noteNumber, osc);
                    SoundFontOscillator layerOsc = new SoundFontOscillator(this, noteNumber, velocity);
                    layerOsc.setNoteNumber(noteNumber, -this.samplerSettings.getFreqSpread() * 0.33f, 0.33f);
                    layerOsc.setVelocity(velocity);
                    osc.addLayer(layerOsc);
                    layerOsc = new SoundFontOscillator(this, noteNumber, velocity);
                    layerOsc.setNoteNumber(noteNumber, this.samplerSettings.getFreqSpread() * 0.33f, 0.66f);
                    layerOsc.setVelocity(velocity);
                    osc.addLayer(layerOsc);
                    layerOsc = new SoundFontOscillator(this, noteNumber, velocity);
                    layerOsc.setNoteNumber(noteNumber, this.samplerSettings.getFreqSpread(), 1.0f);
                    layerOsc.setVelocity(velocity);
                    osc.addLayer(layerOsc);
                    break;
                }
                case 5: {
                    SoundFontOscillator osc = new SoundFontOscillator(this, noteNumber, velocity);
                    osc.setNoteNumber(noteNumber, -this.samplerSettings.getFreqSpread(), 0.0f);
                    osc.setVelocity(velocity);
                    this.addOscillator(noteNumber, osc);
                    SoundFontOscillator layerOsc = new SoundFontOscillator(this, noteNumber, velocity);
                    layerOsc.setNoteNumber(noteNumber, -this.samplerSettings.getFreqSpread() * 0.33f, 0.33f);
                    layerOsc.setVelocity(velocity);
                    osc.addLayer(layerOsc);
                    layerOsc = new SoundFontOscillator(this, noteNumber, velocity);
                    layerOsc.setNoteNumber(noteNumber, 0.0f, 0.5f);
                    layerOsc.setVelocity(velocity);
                    osc.addLayer(layerOsc);
                    layerOsc = new SoundFontOscillator(this, noteNumber, velocity);
                    layerOsc.setNoteNumber(noteNumber, this.samplerSettings.getFreqSpread() * 0.33f, 0.66f);
                    layerOsc.setVelocity(velocity);
                    osc.addLayer(layerOsc);
                    layerOsc = new SoundFontOscillator(this, noteNumber, velocity);
                    layerOsc.setNoteNumber(noteNumber, this.samplerSettings.getFreqSpread(), 1.0f);
                    layerOsc.setVelocity(velocity);
                    osc.addLayer(layerOsc);
                    break;
                }
                case 6: {
                    SoundFontOscillator osc = new SoundFontOscillator(this, noteNumber, velocity);
                    osc.setNoteNumber(noteNumber, -this.samplerSettings.getFreqSpread(), 0.0f);
                    osc.setVelocity(velocity);
                    this.addOscillator(noteNumber, osc);
                    SoundFontOscillator layerOsc = new SoundFontOscillator(this, noteNumber, velocity);
                    layerOsc.setNoteNumber(noteNumber, -this.samplerSettings.getFreqSpread() * 0.6f, 0.33f);
                    layerOsc.setVelocity(velocity);
                    osc.addLayer(layerOsc);
                    layerOsc = new SoundFontOscillator(this, noteNumber, velocity);
                    layerOsc.setNoteNumber(noteNumber, -this.samplerSettings.getFreqSpread() * 0.2f, 0.33f);
                    layerOsc.setVelocity(velocity);
                    osc.addLayer(layerOsc);
                    layerOsc = new SoundFontOscillator(this, noteNumber, velocity);
                    layerOsc.setNoteNumber(noteNumber, this.samplerSettings.getFreqSpread() * 0.2f, 0.66f);
                    layerOsc.setVelocity(velocity);
                    osc.addLayer(layerOsc);
                    layerOsc = new SoundFontOscillator(this, noteNumber, velocity);
                    layerOsc.setNoteNumber(noteNumber, this.samplerSettings.getFreqSpread() * 0.6f, 0.66f);
                    layerOsc.setVelocity(velocity);
                    osc.addLayer(layerOsc);
                    layerOsc = new SoundFontOscillator(this, noteNumber, velocity);
                    layerOsc.setNoteNumber(noteNumber, this.samplerSettings.getFreqSpread(), 1.0f);
                    layerOsc.setVelocity(velocity);
                    osc.addLayer(layerOsc);
                    break;
                }
                default: {
                    SoundFontOscillator osc = new SoundFontOscillator(this, noteNumber, velocity);
                    osc.setNoteNumber(noteNumber, 0.0f, 0.5f);
                    osc.setVelocity(velocity);
                    this.addOscillator(noteNumber, osc);
                }
            }
        }
    }

    public void showGUI() {
        this.gui = new SamplerGUI(this);
    }

    public String toString() {
        return "MS: " + this.getInstrumentName();
    }

    public class SoundFontOscillator
    extends Oscillator {
        SampledSoundSettings sampledSound;
        float samplesPerPeriod;
        float samplePos;
        float sampleIncrement;
        float dBFactor;
        int velocity;
        int noteNumber;
        float attenuationPerSample;
        short[] leftSamples;
        short[] rightSamples;
        int loopStart;
        int loopEnd;
        int sampleMode;
        float leftLevel;
        float rightLevel;
        VolumeEnvelope envelope;
        Vector<SoundFontOscillator> layers;

        public SoundFontOscillator(Synth synth, int noteNumber, int velocity) {
            super(synth);
            this.samplesPerPeriod = 871.74f;
            this.samplePos = 0.0f;
            this.dBFactor = 1.0f;
            this.attenuationPerSample = 0.1f;
            this.envelope = new VolumeEnvelope(this.sampleRate, -100.0f, 0.0f);
            this.layers = new Vector();
            this.velocity = velocity;
            this.noteNumber = noteNumber;
        }

        public void addLayer(SoundFontOscillator osc) {
            this.layers.add(osc);
        }

        public void terminate() {
            this.attenuationPerSample = this.envelope.getAttenuationPerSample(-100.0f, Short.MIN_VALUE);
            this.release();
        }

        public void setNoteNumber(int noteNumber, float customFineTune, float customPan) {
            this.noteNumber = noteNumber;
            this.sampledSound = MySampler.this.sampledSounds[noteNumber][this.velocity];
            this.leftSamples = this.sampledSound.getLeftSamples();
            this.rightSamples = this.sampledSound.getRightSamples();
            this.loopStart = this.sampledSound.getLoopStart();
            this.loopEnd = this.sampledSound.getLoopEnd();
            this.sampleMode = this.sampledSound.getSampleMode();
            this.attenuationPerSample = this.envelope.getAttenuationPerSample(-100.0f, this.sampledSound.getRelease());
            float rootFreq = SoundFontOscillator.getFrequency(this.sampledSound.getRootKey());
            this.samplesPerPeriod = (float)this.sampledSound.getSampleRate() / rootFreq * PitchCents.getPitchCent(this.sampledSound.getFineTune()) * PitchCents.getRealPitchCent(customFineTune);
            this.frequency = rootFreq + (SoundFontOscillator.getFrequency(noteNumber) - rootFreq) * ((float)this.sampledSound.getScaleTune() / 100.0f);
            this.updateIncrement();
            this.sampleIncrement = (float)((double)this.increment / (Math.PI * 2) * (double)this.samplesPerPeriod);
            Pan pan = new Pan(customPan);
            this.leftLevel = pan.getLeftLevel();
            this.rightLevel = pan.getRightLevel();
            if (this.sampledSound.getExclusiveClass() > 0) {
                Vector<SoundFontOscillator> exOscillators;
                int exclusiveClass = this.sampledSound.getExclusiveClass();
                if (MySampler.this.exclusiveClasses.containsKey(exclusiveClass)) {
                    exOscillators = MySampler.this.exclusiveClasses.get(exclusiveClass);
                    if (exOscillators.get((int)0).noteNumber == noteNumber) {
                        exOscillators.add(this);
                    } else {
                        for (SoundFontOscillator exOscillator : exOscillators) {
                            exOscillator.terminate();
                        }
                        MySampler.this.exclusiveClasses.remove(exclusiveClass);
                    }
                }
                if (!MySampler.this.exclusiveClasses.containsKey(exclusiveClass)) {
                    exOscillators = new Vector();
                    exOscillators.add(this);
                    MySampler.this.exclusiveClasses.put(exclusiveClass, exOscillators);
                }
            }
        }

        public final void fillBuffer(int startBufferPos, int endBufferPos, float[] buffer) {
            int n = startBufferPos;
            while (n < endBufferPos) {
                float left = 0.0f;
                float right = 0.0f;
                if (this.samplePos < (float)(this.rightSamples.length - 1)) {
                    int x1 = (int)this.samplePos;
                    int x2 = x1 + 1;
                    float posMinusX1 = this.samplePos - (float)x1;
                    short y1 = this.rightSamples[x1];
                    float dydx = this.rightSamples[x2] - y1;
                    right = (dydx * posMinusX1 + (float)y1) * this.level / 32768.0f;
                    y1 = this.leftSamples[x1];
                    dydx = this.leftSamples[x2] - y1;
                    left = (dydx * posMinusX1 + (float)y1) * this.level / 32768.0f;
                    if ((double)this.dBFactor > 0.01) {
                        left *= this.dBFactor * this.leftLevel;
                        right *= this.dBFactor * this.rightLevel;
                        if (this.release) {
                            this.dBFactor *= this.attenuationPerSample;
                        }
                        this.samplePos += this.sampleIncrement * MySampler.this.preOscillator.getLfoBuffer()[n / 2];
                        int n2 = n++;
                        ((MySampler)MySampler.this).preOscillator.sampleBuffer[n2] = ((MySampler)MySampler.this).preOscillator.sampleBuffer[n2] + left;
                        int n3 = n++;
                        ((MySampler)MySampler.this).preOscillator.sampleBuffer[n3] = ((MySampler)MySampler.this).preOscillator.sampleBuffer[n3] + right;
                        if (this.sampleMode != 1 || !(this.samplePos >= (float)this.loopEnd)) continue;
                        this.samplePos = (float)this.loopStart + (this.samplePos - (float)this.loopEnd);
                        continue;
                    }
                    MySampler.this.getAudioOutput().removeTransmitter(this);
                    break;
                }
                MySampler.this.getAudioOutput().removeTransmitter(this);
                break;
            }
            for (SoundFontOscillator osc : this.layers) {
                osc.release = this.release;
                osc.fillBuffer(startBufferPos, endBufferPos, buffer);
            }
        }
    }

    public class SamplingOscillator
    extends Oscillator {
        int velocity;
        int noteNumber;
        boolean releaseTriggered;

        public SamplingOscillator(Synth synth, int noteNumber, int velocity) {
            super(synth);
            this.releaseTriggered = false;
            System.out.println(velocity);
            this.velocity = velocity;
            this.noteNumber = noteNumber;
        }

        public void release() {
            if (!this.releaseTriggered) {
                this.releaseTriggered = true;
                SampledSound20050403 sampledSound = new SampledSound20050403();
                short[][] samples = ((MySampler)this.synth).samplerOscillator.stopRecording();
                sampledSound.setLeftSamples(samples[0]);
                sampledSound.setRightSamples(samples[1] == null ? samples[0] : samples[1]);
                sampledSound.setRootKey(this.noteNumber);
                sampledSound.setSampleRate(FrinikaConfig.sampleRate);
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                sampledSound.setSampleName(dateFormat.format(new Date()));
                switch (MySampler.this.recordMode) {
                    case 0: {
                        for (int v = 0; v < 128; ++v) {
                            ((MySampler)this.synth).insertSample(sampledSound, this.noteNumber, v);
                        }
                        break;
                    }
                    case 1: {
                        for (int n = 0; n < 96; ++n) {
                            for (int v = 0; v < 128; ++v) {
                                ((MySampler)this.synth).insertSample(sampledSound, n, v);
                            }
                        }
                        break;
                    }
                    case 2: {
                        MySampler.this.gui.insertSampleToSelection(sampledSound);
                    }
                }
                ((MySampler)this.synth).samplerOscillator.stopMonitor();
                System.out.println("Record stored");
                MySampler.this.getAudioOutput().removeTransmitter(this);
            }
        }

        public final void fillBuffer(int startBufferPos, int endBufferPos, float[] buffer) {
        }
    }
}

