/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth.synths.analogika;

import com.frinika.synth.InstrumentNameListener;
import com.frinika.synth.Synth;
import com.frinika.synth.synths.Analogika;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AnalogikaGUI
extends JFrame
implements InstrumentNameListener {
    private static final long serialVersionUID = 1L;
    Analogika analogika;

    public AnalogikaGUI(Analogika analogika) {
        this.analogika = analogika;
        this.initComponents();
        this.setTitle(analogika.getInstrumentName());
        analogika.addInstrumentNameListener(this);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                AnalogikaGUI.this.analogika.removeInstrumentNameListener(AnalogikaGUI.this);
            }
        });
        this.setVisible(true);
        this.setSize(this.getPreferredSize());
    }

    void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridwidth = 0;
        gc.fill = 2;
        JMenuBar menuBar = new JMenuBar();
        this.add((Component)menuBar, gc);
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        JMenuItem renameMenuItem = new JMenuItem("Rename");
        renameMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnalogikaGUI.this.analogika.setInstrumentName(JOptionPane.showInputDialog("Enter new name", (Object)AnalogikaGUI.this.analogika.getInstrumentName()));
            }
        });
        fileMenu.add(renameMenuItem);
        gc.fill = 0;
        gc.ipadx = 5;
        gc.ipady = 5;
        gc.anchor = 10;
        JComboBox<String> waveformCombo = new JComboBox<String>();
        waveformCombo.addItem("saw");
        waveformCombo.addItem("sine");
        waveformCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                float[] waveform = new float[62831];
                if (e.getStateChange() == 1) {
                    for (float n = 0.0f; n < (float)waveform.length; n += 1.0f) {
                        if (e.getItem().equals("sine")) {
                            waveform[(int)n] = (float)Math.sin((double)(n / (float)waveform.length) * Math.PI * 2.0);
                            continue;
                        }
                        if (!e.getItem().equals("saw")) continue;
                        waveform[(int)n] = n / (float)waveform.length - 0.5f;
                    }
                }
                AnalogikaGUI.this.analogika.getAnalogikaSettings().setWaveform(waveform);
            }
        });
        this.add(waveformCombo, gc);
        final JComboBox<Integer> layerComboBox = new JComboBox<Integer>();
        for (int n = 1; n <= 8; ++n) {
            layerComboBox.addItem(new Integer(n));
        }
        layerComboBox.setSelectedIndex(this.analogika.getAnalogikaSettings().getLayers() - 1);
        layerComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AnalogikaGUI.this.analogika.getAnalogikaSettings().setLayers(layerComboBox.getSelectedIndex() + 1);
            }
        });
        this.add((Component)new JLabel("Layers"), gc);
        this.add(layerComboBox, gc);
        final JSlider freqSpreadSlider = new JSlider(0, 0, 1000, (int)(this.analogika.getAnalogikaSettings().getFreqSpread() * 50000.0f));
        freqSpreadSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AnalogikaGUI.this.analogika.getAnalogikaSettings().setFreqSpread((float)freqSpreadSlider.getValue() / 50000.0f);
            }
        });
        this.add((Component)new JLabel("Frequency spread"), gc);
        this.add((Component)freqSpreadSlider, gc);
        final JSlider volAttackSlider = new JSlider(0, -10000, 5000, this.analogika.getAnalogikaSettings().getVolAttack());
        volAttackSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AnalogikaGUI.this.analogika.getAnalogikaSettings().setVolAttack(volAttackSlider.getValue());
            }
        });
        this.add((Component)new JLabel("Attack"), gc);
        this.add((Component)volAttackSlider, gc);
        final JSlider volDecaySlider = new JSlider(0, -10000, 5000, this.analogika.getAnalogikaSettings().getVolDecay());
        volDecaySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AnalogikaGUI.this.analogika.getAnalogikaSettings().setVolDecay(volDecaySlider.getValue());
            }
        });
        this.add((Component)new JLabel("Decay"), gc);
        this.add((Component)volDecaySlider, gc);
        final JSlider volSustainSlider = new JSlider(0, 0, 400, this.analogika.getAnalogikaSettings().getVolSustain());
        volSustainSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AnalogikaGUI.this.analogika.getAnalogikaSettings().setVolSustain(volSustainSlider.getValue());
            }
        });
        this.add((Component)new JLabel("Sustain"), gc);
        this.add((Component)volSustainSlider, gc);
        final JSlider volReleaseSlider = new JSlider(0, -10000, 5000, this.analogika.getAnalogikaSettings().getVolRelease());
        volReleaseSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AnalogikaGUI.this.analogika.getAnalogikaSettings().setVolRelease(volReleaseSlider.getValue());
            }
        });
        this.add((Component)new JLabel("Release"), gc);
        this.add((Component)volReleaseSlider, gc);
        final JSlider loPassMaxSlider = new JSlider(0, 0, 1000, this.analogika.getAnalogikaSettings().getLoPassMax());
        loPassMaxSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AnalogikaGUI.this.analogika.getAnalogikaSettings().setLoPassMax(loPassMaxSlider.getValue());
            }
        });
        this.add((Component)new JLabel("LoPass Peak"), gc);
        this.add((Component)loPassMaxSlider, gc);
        final JSlider loPassAttackSlider = new JSlider(0, -10000, 5000, this.analogika.getAnalogikaSettings().getLoPassAttack());
        loPassAttackSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AnalogikaGUI.this.analogika.getAnalogikaSettings().setLoPassAttack(loPassAttackSlider.getValue());
            }
        });
        this.add((Component)new JLabel("LoPass Attack"), gc);
        this.add((Component)loPassAttackSlider, gc);
        final JSlider loPassDecaySlider = new JSlider(0, -10000, 5000, this.analogika.getAnalogikaSettings().getLoPassDecay());
        loPassDecaySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AnalogikaGUI.this.analogika.getAnalogikaSettings().setLoPassDecay(loPassDecaySlider.getValue());
            }
        });
        this.add((Component)new JLabel("LoPass Decay"), gc);
        this.add((Component)loPassDecaySlider, gc);
        final JSlider loPassSustainSlider = new JSlider(0, 0, 1000, this.analogika.getAnalogikaSettings().getLoPassSustain());
        loPassSustainSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AnalogikaGUI.this.analogika.getAnalogikaSettings().setLoPassSustain(loPassSustainSlider.getValue());
            }
        });
        this.add((Component)new JLabel("LoPass Sustain"), gc);
        this.add((Component)loPassSustainSlider, gc);
        final JSlider loPassReleaseSlider = new JSlider(0, -10000, 5000, this.analogika.getAnalogikaSettings().getLoPassRelease());
        loPassReleaseSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AnalogikaGUI.this.analogika.getAnalogikaSettings().setLoPassRelease(loPassReleaseSlider.getValue());
            }
        });
        this.add((Component)new JLabel("LoPass Release"), gc);
        this.add((Component)loPassReleaseSlider, gc);
    }

    public void instrumentNameChange(Synth synth, String instrumentName) {
        this.setTitle(instrumentName);
    }
}

