/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth.synths.sampler;

import com.frinika.synth.synths.sampler.RecordProgressListener;
import com.frinika.synth.synths.sampler.SamplerOscillator;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class RecorderGUI
extends JFrame
implements RecordProgressListener {
    private static final long serialVersionUID = 1L;
    private JProgressBar progressBar;
    private JLabel stageLabel;
    private int stage = 0;
    private SamplerOscillator samplerOscillator;

    public RecorderGUI(SamplerOscillator samplerOscillator) {
        this.samplerOscillator = samplerOscillator;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        this.setDefaultCloseOperation(2);
        this.stageLabel = new JLabel("Waiting for MIDI note on to start recording");
        new Thread(){

            public void run() {
                while (RecorderGUI.this.stage == 0) {
                    if (RecorderGUI.this.stage == 0) {
                        RecorderGUI.this.stageLabel.setForeground(Color.BLACK);
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (RecorderGUI.this.stage == 0) {
                        RecorderGUI.this.stageLabel.setForeground(RecorderGUI.this.stageLabel.getBackground());
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {}
                }
            }
        }.start();
        this.add((Component)this.stageLabel, gc);
        this.add((Component)new JLabel(" "), gc);
        this.add((Component)new JLabel("Memory usage:"), gc);
        this.progressBar = new JProgressBar(0, samplerOscillator.available());
        this.progressBar.setStringPainted(true);
        this.add((Component)this.progressBar, gc);
        samplerOscillator.setRecordProgressListener(this);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    public void updateProgress(int samplesRecorded) {
        if (samplesRecorded > 0 && this.stage == 0) {
            this.stage = 1;
            this.stageLabel.setForeground(Color.RED);
            this.stageLabel.setText("Recording until MIDI note off");
        }
        this.progressBar.setValue(samplesRecorded);
    }

    public void finished() {
        this.stageLabel.setForeground(Color.GREEN);
        this.stageLabel.setText("Finished recording");
        this.stage = 2;
        this.samplerOscillator.setRecordProgressListener(null);
    }
}

