/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth.synths.sampler;

import com.frinika.audio.Decibel;
import com.frinika.synth.synths.sampler.SampleGraph;
import com.frinika.synth.synths.sampler.settings.SampledSoundSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class SampleEditor
extends JFrame {
    SampledSoundSettings sampledSound;

    public SampleEditor(SampledSoundSettings sampledSound) {
        this.sampledSound = sampledSound;
        this.setTitle(((Object)sampledSound).toString());
        this.setLayout(new BorderLayout());
        this.add((Component)new SampleGraph(sampledSound.getLeftSamples()), "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu editMenu = new JMenu("Edit");
        JMenuItem renameMenuItem = new JMenuItem("Rename");
        renameMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SampleEditor.this.sampledSound.setSampleName(JOptionPane.showInputDialog("Enter new name", (Object)SampleEditor.this.sampledSound.getSampleName()));
            }
        });
        editMenu.add(renameMenuItem);
        menuBar.add(editMenu);
        JMenu processMenu = new JMenu("Process");
        JMenuItem normalizeMenuItem = new JMenuItem("Normalize");
        normalizeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int n;
                short[] leftSamples = SampleEditor.this.sampledSound.getLeftSamples();
                int maxVal = 0;
                for (n = 0; n < leftSamples.length; ++n) {
                    if (Math.abs(leftSamples[n]) <= maxVal) continue;
                    maxVal = Math.abs(leftSamples[n]);
                }
                System.out.println("Normalizing " + maxVal + " " + 32767.0 / (double)maxVal);
                n = 0;
                while (n < leftSamples.length) {
                    int n2 = n++;
                    leftSamples[n2] = (short)((double)leftSamples[n2] * (32767.0 / (double)maxVal));
                }
                SampleEditor.this.repaint();
            }
        });
        processMenu.add(normalizeMenuItem);
        JMenuItem plus3dBMenuItem = new JMenuItem("Plus 3 dB");
        plus3dBMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                short[] leftSamples = SampleEditor.this.sampledSound.getLeftSamples();
                System.out.println("multiplying every sample with: " + Decibel.getAmplitudeRatio(3.0f));
                for (int n = 0; n < leftSamples.length; ++n) {
                    int sample = (int)((float)leftSamples[n] * Decibel.getAmplitudeRatio(3.0f));
                    if (sample > Short.MAX_VALUE) {
                        sample = Short.MAX_VALUE;
                    }
                    if (sample < Short.MIN_VALUE) {
                        sample = Short.MIN_VALUE;
                    }
                    leftSamples[n] = (short)sample;
                }
                SampleEditor.this.repaint();
            }
        });
        processMenu.add(plus3dBMenuItem);
        JMenuItem minus3dBMenuItem = new JMenuItem("Minus 3 dB");
        minus3dBMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                short[] leftSamples = SampleEditor.this.sampledSound.getLeftSamples();
                int n = 0;
                while (n < leftSamples.length) {
                    int n2 = n++;
                    leftSamples[n2] = (short)((float)leftSamples[n2] * Decibel.getAmplitudeRatio(-3.0f));
                }
                SampleEditor.this.repaint();
            }
        });
        processMenu.add(minus3dBMenuItem);
        menuBar.add(processMenu);
        this.add((Component)menuBar, "North");
        this.setSize(500, 500);
        this.setVisible(true);
    }
}

