/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth.synths.sampler;

import com.frinika.synth.synths.sampler.settings.SampledSoundSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class SampleMapTableRenderer
extends Component
implements TableCellRenderer {
    SampleMapCellInfo current;
    SampleMapCellInfo[][] sampleMapCellInfo = new SampleMapCellInfo[96][128];

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setBackground(Color.BLUE);
        }
        if (this.sampleMapCellInfo[row][column] == null || this.sampleMapCellInfo[row][column].sampledSound != value) {
            this.findStartColumn(table, (SampledSoundSettings)value, row, column);
            try {
                if (value.toString().equals(table.getValueAt(row, column + 1).toString())) {
                    this.sampleMapCellInfo[row][column].isEndColumn = false;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.current = this.sampleMapCellInfo[row][column];
        return this;
    }

    int findStartColumn(JTable table, SampledSoundSettings value, int row, int column) {
        try {
            if (value != null && ((Object)value).toString().equals(table.getValueAt(row, column).toString())) {
                int startColumn = this.findStartColumn(table, value, row, column - 1);
                if (this.sampleMapCellInfo[row][column] == null) {
                    this.sampleMapCellInfo[row][column] = new SampleMapCellInfo();
                    this.sampleMapCellInfo[row][column].sampledSound = value;
                    this.sampleMapCellInfo[row][column].startX = startColumn - column;
                }
                return startColumn;
            }
            return column + 1;
        }
        catch (NullPointerException e) {
            return column + 1;
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width, height);
        g.setColor(Color.BLACK);
        if (this.current != null) {
            if (this.current.startX == 0) {
                g.drawLine(0, 0, 0, height);
            }
            if (this.current.isEndColumn) {
                g.drawLine(width - 1, 0, width - 1, height);
            }
            g.drawLine(0, 0, width, 0);
            g.drawLine(0, height - 1, width, height - 1);
            g.drawString(((Object)this.current.sampledSound).toString(), this.current.startX * width + 10, 12);
        }
    }

    public class SampleMapCellInfo {
        SampledSoundSettings sampledSound;
        int startX;
        boolean isEndColumn = true;
    }
}

