/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bath.gui.vamp;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.ShortMessage;
import uk.ac.bath.gui.vamp.IPatchDriver;
import uk.ac.bath.gui.vamp.ISender;

class CCSender
extends ISender {
    private int param;
    private int multiplier;
    private boolean reverse = false;
    private int offset = 0;

    CCSender(int param) {
        this(param, 1, false, 0);
    }

    CCSender(int param, boolean reverse) {
        this(param, 1, reverse, 0);
    }

    CCSender(int param, int multiplier) {
        this(param, multiplier, false, 0);
    }

    CCSender(int param, boolean reverse, int offset) {
        this(param, 1, reverse, offset);
    }

    private CCSender(int param, int multiplier, boolean reverse, int offset) {
        this.param = param;
        this.multiplier = multiplier;
        this.reverse = reverse;
        this.offset = offset;
    }

    public void send(IPatchDriver driver, int value) {
        value = Math.min(127, value * this.multiplier);
        if (this.reverse) {
            value = 127 - value;
        }
        value = Math.min(127, value + this.offset);
        ShortMessage m = new ShortMessage();
        try {
            m.setMessage(176, driver.getChannel(), this.param, value);
            driver.send(m);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }
}

