/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bath.gui.vamp;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.sound.midi.Patch;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import uk.ac.bath.gui.vamp.AmpSelectModel;
import uk.ac.bath.gui.vamp.CCSender;
import uk.ac.bath.gui.vamp.CheckBoxWidget;
import uk.ac.bath.gui.vamp.ComboBoxWidget;
import uk.ac.bath.gui.vamp.KnobWidget;

public class VAmp2Editor
implements ActionListener {
    private static final String[] AMP_MODEL_STRING = new String[]{"American Blues", "Modern Class A", "Tweed Combo", "Classic Clean", "Brit. Blues", "Brit. Class A", "Brit. Classic", "Brit. Hi Gain", "Rectified Hi Gain", "Modern Hi Gain", "Fuzz Box", "Ultimate V-Amp", "Drive V-Amp", "Crunch V-Amp", "Clean V-Amp", "Tube Preamp", "And Deluxe", "Custom Class A", "Small Combo", "Black Twin", "And Custom", "Non Top Boost", "Classic 50 W", "Brit. Class A 15 W", "Rectified Head", "Savage Beast", "Custom Hi Gain", "Ultimate Plus", "Calif. Drive", "Custom Drive", "Calif. Clean", "Custom Clean"};
    private static final String[] CAB_MODEL_STRING = new String[]{"No Cabinet", "1 x 8'' Vintage Tweed", "4 x 10'' Vintage Bass", "4 x 10'' V-AMP Custom", "1 x 12'' Mid Combo", "1 x 12'' Blackface", "1 x 12'' Brit '60", "1 x 12'' Deluxe '52", "2 x 12'' Twin Combo", "2 x 12'' US Class A", "2 x 12'' V-AMP Custom", "2 x 12'' Brit '67", "4 x 12'' Vintage 30", "4 x 12'' Standard '78", "4 x 12'' Off Axis", "4 x 12'' V-AMP Custom"};
    private static final String[] EFF_NAME = new String[]{"Echo", "Delay", "Ping Pong", "Phaser/Delay", "Flanger/Delay 1", "Flanger/Delay 2", "Chorus/Delay 1", "Chorus/Delay 2", "Chorus/Compressor", "Compressor", "Auto Wah", "Phaser", "Chorus", "Flanger", "Tremolo", "Rotary"};
    private static final String[] EFF_PANEL_NAME = new String[]{"Delay", "Mod/Delay", "Chorus/Comp", "Compressor", "Auto Wah", "Phaser/Flanger", "Chorus/Rotary", "Tremelo"};
    private static final int[] EFF_PANEL_ASSGNMT = new int[]{0, 0, 0, 1, 1, 1, 1, 1, 2, 3, 4, 5, 6, 5, 7, 6};
    private static final String[] COMPRESSOR_OPTIONS = new String[]{"1.2:1", "1.4:1", "2:1", "2.5:1", "3:1", "4.5:1"};
    private static final String[] REVERB_TYPE = new String[]{"Tiny Rm", "Small Rm", "Medium Rm", "Large Rm", "Ultra Rm", "Small Spr", "Med Spr", "Short Amb", "Long Amb"};
    private int posWidgetCount = 1;
    private AmpSelectModel ampSelectModel = null;
    private JPanel effParmsPanel;
    JPanel mainPanel;
    private CheckBoxWidget effectsSwitch;
    int protoWidgetCount = 1;
    private String[] ctlNames = new String[]{"(0)", "(1)Wah Pdl", "(2)", "(3)", "(4)", "(5)", "(6)", "(7)Vol Pdl", "(8)", "(9)", "(10)", "(11)", "(12)Gain", "(13)Treble", "(14)Mid", "(15)Bass", "(16)Vol", "(17)Pres", "(18)Rev Mix", "(19)Amp Tp w/def", "(20)Fx Tp w/def", "(21)Fx 0/1", "(22)Rev Send 0/1", "(23)Cab Type", "(24)Rev Type", "(25)Gate Lev", "(26)Drive 0/1", "(27)Wah 0/pos", "(28)", "(29)", "(30)", "(31)", "(32)", "(33)", "(34)", "(35)", "(36)", "(37)", "(38)", "(39)", "(40)", "(41)", "(42)", "(43)", "(44)pre Eff Tp", "(45)pre Eff Par 1", "(46)pre Eff Par 2", "(47)pre Eff Par 3", "(48)pre Eff Par 4", "(49)Del Tp", "(50)Del Tm hi", "(51)Del Tm lo", "(52)Del Spr", "(53)Del Fdbk", "(54)Del Mix", "(55)post Fx Mode", "(56)post Fx Par 1", "(57)post Fx Par 2", "(58)post Fx Par 3", "(59)post Fx Mix", "(60)Assgn Eff Ctrl", "(61)Amp Type no cab", "(62)", "(62)", "(64)Tap", "(65)", "(66)", "(67)", "(68)", "(69)", "(70)", "(71)", "(72)", "(73)", "(74)", "(75)", "(76)", "(77)", "(78)", "(79)", "(80)Req Ctrls", "(81)Curs Pos/Char", "(82)Tune Bp Vol", "(83)Tune Ctr Frq", "(84)Config", "(85)Live EQ Trb", "(86)Live EQ Mid", "(87)Live EQ Bass", "(88)Dig Out", "(89)Inp Gain", "(90)Wah char"};

    VAmp2Editor(Patch patch) {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 0));
        this.mainPanel.add(this.newLeftPanel(patch));
        this.mainPanel.add(this.newRightPanel(patch));
    }

    private JPanel newLeftPanel(Patch patch) {
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BoxLayout(aPanel, 1));
        aPanel.add(this.newAmpModelPanel(patch));
        aPanel.add(this.newPreampPanel(patch));
        return aPanel;
    }

    private JPanel newAmpModelPanel(Patch patch) {
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BoxLayout(aPanel, 1));
        aPanel.setBorder(new TitledBorder(new EtchedBorder(0), "Amp Model", 2, 2));
        ComboBoxWidget ampSelectCB = this.newComboBoxWidget(aPanel, "Amp Model", patch, 7, 61, AMP_MODEL_STRING);
        this.ampSelectModel = new AmpSelectModel(ampSelectCB, aPanel);
        ComboBoxWidget cabSelectCB = this.newComboBoxWidget(aPanel, "Cabinet Model", patch, 11, 23, CAB_MODEL_STRING);
        return aPanel;
    }

    private JPanel newPreampPanel(Patch patch) {
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BoxLayout(aPanel, 1));
        aPanel.setBorder(new TitledBorder(new EtchedBorder(0), "Preamp", 2, 2));
        aPanel.add(this.newDriveSwitchPanel(patch));
        aPanel.add(this.newPreampCtrlsPanel(patch));
        return aPanel;
    }

    private JPanel newDriveSwitchPanel(Patch patch) {
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BoxLayout(aPanel, 0));
        CheckBoxWidget c = this.newCheckBoxWidget(aPanel, "Drive", patch, 14, 26);
        this.effectsSwitch = this.newCheckBoxWidget(aPanel, "Effects", patch, 9, 21);
        c = this.newCheckBoxWidget(aPanel, "Reverb", patch, 10, 22);
        return aPanel;
    }

    private JPanel newPreampCtrlsPanel(Patch patch) {
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BoxLayout(aPanel, 0));
        this.addKnobWidget(aPanel, "Gain", patch, 0, 127, 0, 12);
        this.addKnobWidget(aPanel, "Bass", patch, 0, 127, 3, 15);
        this.addKnobWidget(aPanel, "Mid", patch, 0, 127, 2, 14);
        this.addKnobWidget(aPanel, "Treble", patch, 0, 127, 1, 13);
        this.addKnobWidget(aPanel, "Presence", patch, 0, 127, 5, 17);
        this.addKnobWidget(aPanel, "Volume", patch, 0, 127, 4, 16);
        return aPanel;
    }

    private JPanel newRightPanel(Patch patch) {
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BoxLayout(aPanel, 1));
        aPanel.add(new JLabel(" "));
        aPanel.add(new JLabel(" "));
        aPanel.add(this.newEffectsPanel(patch));
        aPanel.add(this.newMiscPanel(patch));
        return aPanel;
    }

    private JPanel newEffectsPanel(Patch patch) {
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BoxLayout(aPanel, 1));
        aPanel.setBorder(new TitledBorder(new EtchedBorder(0), "Effects", 2, 2));
        ComboBoxWidget effectsCB = this.newEffectsComboBoxWidget(aPanel, "Effects", patch, 8, 20, EFF_NAME);
        effectsCB.addEventListener(this);
        this.effParmsPanel = this.newEffParmsPanel(patch);
        this.setEffPanel(effectsCB.getValue());
        aPanel.add(this.effParmsPanel);
        return aPanel;
    }

    public void actionPerformed(ActionEvent e) {
        JComboBox cb = (JComboBox)e.getSource();
        int selectedIndex = cb.getSelectedIndex();
        this.setEffPanel(selectedIndex);
        this.effectsSwitch.setValue(1);
    }

    private void setEffPanel(int selectedIndex) {
        Container selFrame = (Container)this.effParmsPanel.getComponent(EFF_PANEL_ASSGNMT[selectedIndex]);
        for (int i = 0; i < selFrame.getComponentCount(); ++i) {
            Container subFrame = (Container)selFrame.getComponent(i);
            for (int j = 0; j < subFrame.getComponentCount(); ++j) {
                Component aComponent = subFrame.getComponent(j);
            }
        }
        CardLayout cl = (CardLayout)this.effParmsPanel.getLayout();
        cl.show(this.effParmsPanel, EFF_PANEL_NAME[EFF_PANEL_ASSGNMT[selectedIndex]]);
    }

    private JPanel newEffParmsPanel(Patch patch) {
        JPanel aPanel = new JPanel(new CardLayout());
        JPanel[] cardPanel = new JPanel[8];
        for (int i = 0; i < cardPanel.length; ++i) {
            cardPanel[i] = new JPanel();
            aPanel.add((Component)cardPanel[i], EFF_PANEL_NAME[i]);
        }
        this.setupDelayPanel(cardPanel[0], patch);
        this.setupModDelayPanel(cardPanel[1], patch);
        this.setupChorusCompPanel(cardPanel[2], patch);
        this.setupCompressorPanel(cardPanel[3], patch);
        this.setupAutoWahPanel(cardPanel[4], patch);
        this.setupPhaserFlangerPanel(cardPanel[5], patch);
        this.setupChorusRotaryPanel(cardPanel[6], patch);
        this.setupTremeloPanel(cardPanel[7], patch);
        return aPanel;
    }

    private void setupDelayPanel(JPanel parentPanel, Patch patch) {
        JPanel delayParmPanel = new JPanel();
        delayParmPanel.setBorder(new TitledBorder(new EtchedBorder(0), "Delay Parameters", 2, 2));
        this.addKnobWidget(delayParmPanel, "Mix", patch, 0, 127, 26, 54);
        this.addKnobWidget(delayParmPanel, "Feedback", patch, 0, 127, 25, 53);
        this.addKnobWidget(delayParmPanel, "Spread", patch, 0, 127, 24, 52);
        parentPanel.add(delayParmPanel);
        JPanel delayTimePanel = new JPanel();
        delayTimePanel.setBorder(new TitledBorder(new EtchedBorder(0), "Delay Time", 2, 2));
        this.addKnobWidget(delayTimePanel, "Coarse", patch, 0, 117, 22, 50);
        this.addKnobWidget(delayTimePanel, "Fine", patch, 0, 127, 23, 51);
        parentPanel.add(delayTimePanel);
    }

    private void setupModDelayPanel(JPanel parentPanel, Patch patch) {
        JPanel modPanel = new JPanel();
        modPanel.setBorder(new TitledBorder(new EtchedBorder(0), "Modulation", 2, 2));
        this.addKnobWidget(modPanel, "Delay Mix", patch, 0, 127, 26, 54);
        this.addKnobWidget(modPanel, "Mod. Mix", patch, 0, 127, 31, 59);
        this.addKnobWidget(modPanel, "Spread", patch, 0, 127, 24, 52);
        parentPanel.add(modPanel);
        JPanel delayTimePanel = new JPanel();
        delayTimePanel.setBorder(new TitledBorder(new EtchedBorder(0), "Delay Time", 2, 2));
        this.addKnobWidget(delayTimePanel, "Coarse", patch, 0, 117, 22, 50);
        this.addKnobWidget(delayTimePanel, "Fine", patch, 0, 127, 23, 51);
        parentPanel.add(delayTimePanel);
    }

    private void setupChorusCompPanel(JPanel parentPanel, Patch patch) {
        JPanel aPanel = new JPanel();
        aPanel.setBorder(new EtchedBorder(0));
        ComboBoxWidget cb = this.newScaledComboBoxWidget(aPanel, "Sense", patch, 17, 45, COMPRESSOR_OPTIONS);
        this.addKnobWidget(aPanel, "Mod. Mix", patch, 0, 127, 31, 59);
        this.addKnobWidget(aPanel, "Speed", patch, 0, 127, 30, 58);
        parentPanel.add(aPanel);
    }

    private void setupCompressorPanel(JPanel parentPanel, Patch patch) {
        JPanel aPanel = new JPanel();
        aPanel.setBorder(new EtchedBorder(0));
        ComboBoxWidget cb = this.newScaledComboBoxWidget(aPanel, "Sense", patch, 17, 45, COMPRESSOR_OPTIONS);
        this.addKnobWidget(aPanel, "Attack", patch, 0, 127, 18, 46);
        parentPanel.add(aPanel);
    }

    private void setupAutoWahPanel(JPanel parentPanel, Patch patch) {
        JPanel aPanel = new JPanel();
        aPanel.setBorder(new EtchedBorder(0));
        this.addKnobWidget(aPanel, "Depth", patch, 0, 127, 17, 45);
        this.addKnobWidget(aPanel, "Speed", patch, 0, 127, 18, 46);
        parentPanel.add(aPanel);
    }

    private void setupPhaserFlangerPanel(JPanel parentPanel, Patch patch) {
        JPanel aPanel = new JPanel();
        aPanel.setBorder(new EtchedBorder(0));
        this.addKnobWidget(aPanel, "Mix", patch, 0, 127, 31, 59);
        this.addKnobWidget(aPanel, "Feedback", patch, 0, 127, 30, 58);
        this.addKnobWidget(aPanel, "Speed", patch, 0, 127, 28, 56);
        parentPanel.add(aPanel);
    }

    private void setupChorusRotaryPanel(JPanel parentPanel, Patch patch) {
        JPanel aPanel = new JPanel();
        aPanel.setBorder(new EtchedBorder(0));
        this.addKnobWidget(aPanel, "Mix", patch, 0, 127, 31, 59);
        this.addKnobWidget(aPanel, "Depth", patch, 0, 127, 29, 57);
        this.addKnobWidget(aPanel, "Speed", patch, 0, 127, 28, 56);
        parentPanel.add(aPanel);
    }

    private void setupTremeloPanel(JPanel parentPanel, Patch patch) {
        JPanel aPanel = new JPanel();
        aPanel.setBorder(new EtchedBorder(0));
        this.addKnobWidget(aPanel, "Mix", patch, 0, 127, 31, 59);
        this.addKnobWidget(aPanel, "Speed", patch, 0, 127, 28, 56);
        parentPanel.add(aPanel);
    }

    private JPanel newMiscPanel(Patch patch) {
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BoxLayout(aPanel, 0));
        aPanel.add(this.newGatePanel(patch));
        aPanel.add(this.newReverbPanel(patch));
        aPanel.add(this.newWahPanel(patch));
        return aPanel;
    }

    private JPanel newGatePanel(Patch patch) {
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BoxLayout(aPanel, 0));
        aPanel.setBorder(new TitledBorder(new EtchedBorder(0), "Gate", 2, 2));
        this.addKnobWidget(aPanel, "Level", patch, 0, 15, 13, 25);
        return aPanel;
    }

    private JPanel newReverbPanel(Patch patch) {
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BoxLayout(aPanel, 0));
        aPanel.setBorder(new TitledBorder(new EtchedBorder(0), "Reverb", 2, 2));
        ComboBoxWidget reverbCB = this.newComboBoxWidget(aPanel, "Type", patch, 12, 24, REVERB_TYPE);
        this.addKnobWidget(aPanel, "Mix", patch, 0, 127, 6, 18);
        return aPanel;
    }

    private JPanel newWahPanel(Patch patch) {
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BoxLayout(aPanel, 0));
        aPanel.setBorder(new TitledBorder(new EtchedBorder(0), "Wah", 2, 2));
        this.addKnobWidget(aPanel, "Off/Pos.", patch, 0, 127, 15, 27);
        return aPanel;
    }

    private void addKnobWidget(JComponent panel, String wLabel, Patch patch, int min, int max, int sysexOffset, int ccNum) {
        this.addKnobWidget(panel, wLabel, patch, min, max, 0, sysexOffset, ccNum);
    }

    private void addKnobWidget(JComponent panel, String wLabel, Patch patch, int min, int max, int base, int sysexOffset, int ccNum) {
        KnobWidget widget = new KnobWidget(wLabel, min, max, base, null, null, 50, 50);
        panel.add(widget);
    }

    private ComboBoxWidget newComboBoxWidget(JComponent panel, String wLabel, Patch patch, int sysexOffset, int ccNum, Object[] options) {
        ComboBoxWidget cb = new ComboBoxWidget(wLabel, 0, null, options);
        this.addWidget(panel, cb, 0, 0, 1, 1, this.posWidgetCount++);
        return cb;
    }

    private ComboBoxWidget newEffectsComboBoxWidget(JComponent panel, String wLabel, Patch patch, int sysexOffset, int ccNum, Object[] options) {
        ComboBoxWidget cb = new ComboBoxWidget(wLabel, 0, null, options);
        this.addWidget(panel, cb, 0, 0, 1, 1, this.posWidgetCount++);
        return cb;
    }

    private void addWidget(JComponent panel, ComboBoxWidget cb, int i, int j, int k, int l, int m) {
        panel.add(cb);
    }

    private ComboBoxWidget newScaledComboBoxWidget(JComponent panel, String wLabel, Patch patch, int sysexOffset, int ccNum, Object[] options) {
        ComboBoxWidget cb = new ComboBoxWidget(wLabel, 0, null, options);
        this.addWidget(panel, cb, 0, 0, 1, 1, this.posWidgetCount++);
        return cb;
    }

    private CheckBoxWidget newCheckBoxWidget(JComponent panel, String wLabel, Patch patch, int sysexOffset, int ccNum) {
        CheckBoxWidget cb = new CheckBoxWidget(wLabel, new CCSender(ccNum, 127), 0);
        this.addWidget(panel, cb, 0, 0, 1, 1, this.posWidgetCount++);
        return cb;
    }

    private void addWidget(JComponent panel, CheckBoxWidget cb, int i, int j, int k, int l, int m) {
        panel.add(cb);
    }

    private void addProtoEditor(Patch patch, JPanel scrollPane, JPanel mainPanel) {
        JPanel glPanel = new JPanel();
        glPanel.setLayout(new BoxLayout(glPanel, 1));
        int[] group1 = new int[]{18, 24, 25, 27, 44, 47, 48};
        glPanel.add(this.newProtoPane(patch, group1));
        int[] group2 = new int[]{45, 49, 55, 60, 64, 80, 81, 82};
        glPanel.add(this.newProtoPane(patch, group2));
        int[] group3 = new int[]{83, 84, 85, 86, 87, 88, 89};
        glPanel.add(this.newProtoPane(patch, group3));
        JTabbedPane tabbedPane = new JTabbedPane();
        scrollPane.add(tabbedPane);
        tabbedPane.addTab("Development Editor", mainPanel);
        tabbedPane.addTab("Prototype Editor", glPanel);
    }

    private JPanel newProtoPane(Patch patch, int[] cc) {
        JPanel devPanel = new JPanel();
        devPanel.setLayout(new BoxLayout(devPanel, 0));
        devPanel.setBorder(new EtchedBorder(0));
        for (int i = 0; i < cc.length; ++i) {
            this.addWidget(devPanel, new KnobWidget(this.ctlNames[cc[i]], 0, 127, 0, null, null, 40, 40), 0, 0, 1, 1, this.protoWidgetCount);
            ++this.protoWidgetCount;
        }
        return devPanel;
    }

    private void addWidget(JPanel devPanel, KnobWidget widget, int i, int j, int k, int l, int protoWidgetCount2) {
        devPanel.add(widget);
    }

    public static void main(String[] args) {
        Patch patch = new Patch(0, 0);
        VAmp2Editor vamp = new VAmp2Editor(patch);
        JFrame frame = new JFrame();
        frame.setContentPane(vamp.mainPanel);
        frame.pack();
        frame.setVisible(true);
    }
}

