/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bath.test;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;

public class MidiTest {
    public static void main(String[] aegs) {
        MidiDevice dev = MidiTest.getMidiInDevice(11);
        try {
            dev.open();
        }
        catch (MidiUnavailableException e1) {
            e1.printStackTrace();
        }
        Receiver recv = new Receiver(){

            public void close() {
            }

            public void send(MidiMessage shm, long arg1) {
                if (shm instanceof ShortMessage) {
                    if (shm.getLength() < 2) {
                        return;
                    }
                    byte[] b = shm.getMessage();
                    int d1 = b[1] & 0xFF;
                    int d2 = b[2] & 0xFF;
                    System.out.println(d1 + "  " + d2);
                }
            }
        };
        try {
            dev.getTransmitter().setReceiver(recv);
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
        try {
            Thread.sleep(5000000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static MidiDevice getMidiInDevice(int idev) {
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        int i = 0;
        for (MidiDevice.Info info : infos) {
            String str = info.toString();
            if (i == idev) {
                System.out.print("*");
            } else {
                System.out.print(" ");
            }
            System.out.println(str);
            ++i;
        }
        try {
            return MidiSystem.getMidiDevice(infos[idev]);
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
            return null;
        }
    }
}

