/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio;

import java.awt.Dimension;
import java.util.Arrays;
import uk.co.simphoney.audio.OscillatorNode;
import uk.co.simphoney.audio.SpectrogramDataListener;
import uk.co.simphoney.audio.SpectrumDataBuilder;
import uk.co.simphoney.audio.gui.CursorObserver;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioProcess;

public class StaticSpectrogramSynth
implements AudioProcess,
CursorObserver,
SpectrogramDataListener {
    private SpectrumDataBuilder data;
    private int nBins;
    OscillatorNode[] oscBank;
    MagFreq[] magFreq;
    int[] peaks;
    private OscillatorNode[] oscNext;

    public StaticSpectrogramSynth(SpectrumDataBuilder data) {
        this.data = data;
        data.addSizeObserver(this);
    }

    public OscillatorNode[] getOscillatorBank() {
        return this.oscBank;
    }

    private final void activateOscillatorsAtChunk(long chunkPtr) {
        int i;
        if (!this.data.validAt(chunkPtr)) {
            System.out.println(" Data not ready at " + chunkPtr);
            for (OscillatorNode osc : this.oscBank) {
                osc.active = false;
            }
            return;
        }
        float[] freqs = this.data.getFreqArray();
        float[] magn = this.data.getMagnitudeAt(chunkPtr);
        float[] pfreq = this.data.getPhaseFreqAt(chunkPtr);
        float[] phase = this.data.getPhaseFreqAt(chunkPtr);
        int cnt = this.findPeaks(magn, this.peaks, 0.0f);
        for (i = 0; i < cnt; ++i) {
            this.magFreq[i].set(this.peaks[i], magn[this.peaks[i]]);
        }
        Arrays.sort(this.magFreq, 0, cnt);
        System.out.println(" Found " + cnt + " peaks ");
        Arrays.fill(this.oscNext, null);
        for (i = 0; i < cnt; ++i) {
            int ifreq = this.magFreq[i].ifreq;
            if (this.isMasked(ifreq, magn[ifreq])) continue;
            int inear = this.findOscNear(ifreq);
            if (inear != ifreq) {
                this.swap(inear, ifreq);
            }
            this.oscBank[ifreq].setNext(pfreq[ifreq], magn[ifreq], phase[ifreq]);
            this.oscNext[ifreq] = this.oscBank[ifreq];
        }
        for (i = 0; i < this.nBins; ++i) {
            if (this.oscNext[i] != null || !this.oscBank[i].active) continue;
            this.oscBank[i].silence();
        }
    }

    private void swap(int inear, int ifreq) {
        OscillatorNode nn = this.oscBank[inear];
        this.oscBank[inear] = this.oscBank[ifreq];
        this.oscBank[ifreq] = nn;
    }

    private int findOscNear(int ifreq) {
        OscillatorNode osc = this.oscBank[ifreq];
        if (osc.active()) {
            return ifreq;
        }
        if (ifreq < this.nBins && (osc = this.oscBank[ifreq + 1]).active()) {
            return ifreq + 1;
        }
        if (ifreq > 0 && (osc = this.oscBank[ifreq - 1]) != null) {
            return ifreq - 1;
        }
        return ifreq;
    }

    private final boolean isMasked(int ifreq, float f) {
        int i1 = ifreq - 2;
        int i2 = ifreq + 2;
        if (i1 < 0) {
            i1 = 0;
        }
        if (i2 >= this.nBins) {
            i2 = this.nBins - 1;
        }
        for (int i = i1; i <= i2; ++i) {
            if (this.oscNext[i] == null) continue;
            return true;
        }
        return false;
    }

    private final int findPeaks(float[] a, int[] peaks, float threshold) {
        float max = 0.0f;
        int imax = -1;
        int cnt = 0;
        for (int i = 1; i < a.length - 1; ++i) {
            if (a[i] < threshold || !(a[i] >= a[i - 1]) || !(a[i] > a[i + 1])) continue;
            peaks[cnt++] = i;
        }
        return cnt;
    }

    public void close() {
    }

    public void open() {
    }

    void setChunkPtr(long ptr) {
        this.activateOscillatorsAtChunk(ptr);
        System.out.println("OscPlayer set frame " + ptr);
    }

    public int processAudio(AudioBuffer buffer) {
        buffer.makeSilence();
        for (OscillatorNode osc : this.oscBank) {
            if (!osc.active) continue;
            osc.processAudio(buffer);
        }
        return 0;
    }

    public void notifyCursorChange(int pix) {
        this.setChunkPtr(pix);
    }

    public void notifyMoreDataReady() {
    }

    public void notifySizeChange(Dimension d) {
        System.out.println(" Synth SIZE SET ");
        this.nBins = d.height;
        this.oscNext = new OscillatorNode[this.nBins];
        this.magFreq = new MagFreq[this.nBins];
        this.oscBank = new OscillatorNode[this.nBins];
        for (int i = 0; i < this.nBins; ++i) {
            this.magFreq[i] = new MagFreq(i, 0.0f);
            this.oscBank[i] = new OscillatorNode();
        }
        this.peaks = new int[this.nBins];
    }

    final class MagFreq
    implements Comparable {
        int ifreq;
        float magn;

        public MagFreq(int i, float f) {
            this.ifreq = i;
            this.magn = f;
        }

        public final int compareTo(Object o) {
            return Float.compare(this.magn, ((MagFreq)o).magn);
        }

        public final void set(int i, float f) {
            this.ifreq = i;
            this.magn = f;
        }
    }
}

