/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio.constantq;

import com.frinika.sequencer.model.audio.AudioReader;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JPanel;
import uk.ac.bath.gui.TweakerPanel;
import uk.ac.bath.util.Tweakable;
import uk.ac.bath.util.TweakableDouble;
import uk.ac.bath.util.TweakableInt;
import uk.co.simphoney.audio.Mapper;
import uk.co.simphoney.audio.SpectrumController;
import uk.co.simphoney.audio.constantq.ConstantQSpectrogramDataBuilder;

public class ConstantQSpectrumController
implements SpectrumController {
    Vector<Tweakable> tweaks = new Vector();
    TweakableDouble minFreqT = new TweakableDouble(this.tweaks, 1.0, 1000.0, 40.0, 1.0, "min Freq");
    TweakableDouble maxFreqT = new TweakableDouble(this.tweaks, 2.0, 20000.0, 8000.0, 5.0, "max Freq");
    TweakableInt binsPerOctave = new TweakableInt(this.tweaks, 1, 48, 12, "bins/Octave");
    TweakableDouble threshold = new TweakableDouble(this.tweaks, 0.0, 0.1, 0.01, 0.05, "threshold");
    TweakableDouble dt = new TweakableDouble(this.tweaks, 0.001, 0.02, 0.01, 0.001, "dt");
    TweakableDouble spread = new TweakableDouble(this.tweaks, 0.1, 50.0, 1.0, 0.001, "spread");
    private Mapper freqMapper = new Mapper(){
        double minFreq;
        double maxFreq;
        {
            this.minFreq = ConstantQSpectrumController.this.minFreqT.doubleValue();
            this.maxFreq = ConstantQSpectrumController.this.maxFreqT.doubleValue();
        }

        public final float eval(float val) {
            double x = Math.log((double)val / this.minFreq);
            double mx = Math.log(this.maxFreq / this.minFreq);
            return (float)(x / mx);
        }
    };
    Observer reco;

    public ConstantQSpectrumController(final ConstantQSpectrogramDataBuilder spectroData, final AudioReader reader) {
        this.reco = new Observer(){

            public void update(Observable o, Object arg) {
                spectroData.setParameters(reader, ConstantQSpectrumController.this.minFreqT.doubleValue(), ConstantQSpectrumController.this.maxFreqT.doubleValue(), ConstantQSpectrumController.this.binsPerOctave.intValue(), ConstantQSpectrumController.this.threshold.doubleValue(), ConstantQSpectrumController.this.spread.doubleValue(), ConstantQSpectrumController.this.dt.doubleValue());
            }
        };
        this.binsPerOctave.addObserver(this.reco);
        this.maxFreqT.addObserver(this.reco);
        this.minFreqT.addObserver(this.reco);
        this.threshold.addObserver(this.reco);
        this.dt.addObserver(this.reco);
        this.spread.addObserver(this.reco);
    }

    public Mapper getFrequencyMapper() {
        return this.freqMapper;
    }

    public void update() {
        this.reco.update(null, null);
    }

    public JPanel getTweakPanel() {
        TweakerPanel tpanel = new TweakerPanel(2, 4);
        for (Tweakable t : this.tweaks) {
            tpanel.addSpinTweaker(t);
        }
        return tpanel;
    }
}

