/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio.constantq;

import rasmus.interpreter.sampled.util.FFT;

public class DeltaFFTCQ {
    double q;
    int k;
    int fftlen;
    double[] freqs;
    double[][] qKernel;
    int[][] qKernel_indexes;
    double[] deltaFFT;
    FFT fft;
    double sampleRate = 44100.0;
    double minFreq = 100.0;
    double maxFreq = 3000.0;
    double binsPerOctave = 12.0;
    double threshold = 0.001;
    double spread = 1.0;
    String kernelsident;
    private double deltaSamples;

    public FFT getFFT() {
        return this.fft;
    }

    public int getFFTSize() {
        return this.fftlen;
    }

    public int getNumberOfOutputBands() {
        return this.k;
    }

    public DeltaFFTCQ(double sampleRate, double minFreq, double maxFreq, double binsPerOctave) {
        this.sampleRate = sampleRate;
        this.minFreq = minFreq;
        this.maxFreq = maxFreq;
        this.binsPerOctave = binsPerOctave;
        this.init();
    }

    public DeltaFFTCQ(double sampleRate, double minFreq, double maxFreq, double binsPerOctave, double threshold, double deltaSamples) {
        this.sampleRate = sampleRate;
        this.minFreq = minFreq;
        this.maxFreq = maxFreq;
        this.binsPerOctave = binsPerOctave;
        this.threshold = threshold;
        this.deltaSamples = deltaSamples;
        this.init();
    }

    private void init() {
        this.q = 1.0 / (Math.pow(2.0, 1.0 / this.binsPerOctave) - 1.0) / this.spread;
        this.k = (int)Math.ceil(this.binsPerOctave * Math.log(this.maxFreq / this.minFreq) / Math.log(2.0));
        double calc_fftlen = Math.ceil(this.q * this.sampleRate / this.minFreq) + this.deltaSamples;
        this.fftlen = (int)Math.pow(2.0, Math.ceil(Math.log(calc_fftlen) / Math.log(2.0)));
        this.fft = new FFT(this.fftlen);
        this.deltaFFT = new double[this.fftlen];
        for (int j = 0; j < this.fftlen / 2; ++j) {
            double fact = (double)(j * 2) * Math.PI * this.deltaSamples / (double)this.fftlen;
            this.deltaFFT[2 * j] = Math.cos(fact);
            this.deltaFFT[2 * j + 1] = Math.sin(fact);
        }
        this.qKernel = new double[this.k][];
        this.qKernel_indexes = new int[this.k][];
        this.freqs = new double[this.k];
        double[] temp = new double[this.fftlen * 2];
        double[] ctemp = new double[this.fftlen * 2];
        int[] cindexes = new int[this.fftlen];
        for (int i = 0; i < this.k; ++i) {
            int j;
            double[] sKernel = temp;
            this.freqs[i] = this.minFreq * Math.pow(2.0, (double)i / this.binsPerOctave);
            double len = this.q * this.sampleRate / this.freqs[i];
            for (int j2 = 0; j2 < this.fftlen; ++j2) {
                double aa = (double)j2 / len;
                if (aa < 1.0) {
                    double a = Math.PI * 2 * aa;
                    double window = 0.5 * (1.0 - Math.cos(a));
                    double x = Math.PI * 2 * this.freqs[i] * (double)j2 / this.sampleRate;
                    sKernel[j2 * 2] = (window /= len) * Math.cos(x);
                    sKernel[j2 * 2 + 1] = -window * Math.sin(x);
                    continue;
                }
                sKernel[j2 * 2] = 0.0;
                sKernel[j2 * 2 + 1] = 0.0;
            }
            this.fft.calc(sKernel, -1);
            double[] cKernel = ctemp;
            int k = 0;
            int j3 = 0;
            int j2 = sKernel.length - 2;
            while (j3 < sKernel.length / 2) {
                double absval = Math.sqrt(sKernel[j3] * sKernel[j3] + sKernel[j3 + 1] * sKernel[j3 + 1]);
                if ((absval += Math.sqrt(sKernel[j2] * sKernel[j2] + sKernel[j2 + 1] * sKernel[j2 + 1])) > this.threshold) {
                    cindexes[k] = j3;
                    cKernel[2 * k] = sKernel[j3] + sKernel[j2];
                    cKernel[2 * k + 1] = sKernel[j3 + 1] + sKernel[j2 + 1];
                    ++k;
                }
                j3 += 2;
                j2 -= 2;
            }
            sKernel = new double[k * 2];
            int[] indexes = new int[k];
            for (j = 0; j < k * 2; ++j) {
                sKernel[j] = cKernel[j];
            }
            for (j = 0; j < k; ++j) {
                indexes[j] = cindexes[j];
            }
            j = 0;
            while (j < sKernel.length) {
                int n = j++;
                sKernel[n] = sKernel[n] / (double)this.fftlen;
            }
            this.qKernel_indexes[i] = indexes;
            this.qKernel[i] = sKernel;
        }
    }

    public void calc(double[] buff_in, double[] buff_out) {
        this.fft.calcReal(buff_in, -1);
        for (int i = 0; i < this.qKernel.length; ++i) {
            double[] kernel = this.qKernel[i];
            int[] indexes = this.qKernel_indexes[i];
            double t_r = 0.0;
            double t_i = 0.0;
            int j = 0;
            int l = 0;
            while (j < kernel.length) {
                int jj = indexes[l];
                double b_r = buff_in[jj];
                double b_i = buff_in[jj + 1];
                double k_r = kernel[j];
                double k_i = kernel[j + 1];
                t_r += b_r * k_r - b_i * k_i;
                t_i += b_r * k_i + b_i * k_r;
                j += 2;
                ++l;
            }
            buff_out[i * 2] = t_r;
            buff_out[i * 2 + 1] = t_i;
        }
    }

    public void calcShifted(double[] buff_in, double[] buff_out) {
        int i;
        this.fft.calcReal(buff_in, -1);
        for (i = 0; i < this.fftlen / 2; ++i) {
            double t_r = buff_in[2 * i];
            double t_i = buff_in[2 * i + 1];
            buff_in[2 * i] = this.deltaFFT[2 * i] * t_r - this.deltaFFT[2 * i + 1] * t_i;
            buff_in[2 * i + 1] = this.deltaFFT[2 * i] * t_i + this.deltaFFT[2 * i + 1] * t_r;
        }
        buff_in[1] = 0.0;
        buff_in[0] = 0.0;
        for (i = 0; i < this.qKernel.length; ++i) {
            double[] kernel = this.qKernel[i];
            int[] indexes = this.qKernel_indexes[i];
            double t_r = 0.0;
            double t_i = 0.0;
            int j = 0;
            int l = 0;
            while (j < kernel.length) {
                int jj = indexes[l];
                double b_r = buff_in[jj];
                double b_i = buff_in[jj + 1];
                double k_r = kernel[j];
                double k_i = kernel[j + 1];
                t_r += b_r * k_r - b_i * k_i;
                t_i += b_r * k_i + b_i * k_r;
                j += 2;
                ++l;
            }
            buff_out[i * 2] = t_r;
            buff_out[i * 2 + 1] = t_i;
        }
    }

    public int getFFTlength() {
        return this.fftlen;
    }
}

