/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio.dft;

import com.frinika.global.FrinikaConfig;
import rasmus.interpreter.sampled.util.FFT;
import uk.co.simphoney.audio.dft.ChunkReaderProcess;

public class FFTSpectrogramDataBuilder
implements ChunkReaderProcess {
    float[] freqArray;
    private int nBin;
    double Fs = FrinikaConfig.sampleRate;
    int fftsize;
    FFT fft;
    double[] hanning;

    public void setParameters(int fftsize) {
        this.fftsize = fftsize;
        this.fft = new FFT(fftsize);
        this.nBin = fftsize / 2;
        this.hanning = this.fft.wHanning();
        this.freqArray = new float[this.nBin];
        for (int i = 0; i < this.nBin; ++i) {
            this.freqArray[i] = (float)((double)i * this.Fs / (double)this.nBin);
        }
    }

    public int getBinCount() {
        return this.nBin;
    }

    public double[] process(double[] fftInOut) {
        for (int i = 0; i < this.fftsize; ++i) {
            int n = i;
            fftInOut[n] = fftInOut[n] * this.hanning[i];
        }
        this.fft.calcReal(fftInOut, -1);
        return fftInOut;
    }

    public float[] getFreqArray() {
        return this.freqArray;
    }

    public double getSampleRate() {
        return this.Fs;
    }

    public FFT getFFT() {
        return this.fft;
    }
}

