/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio.dft;

import com.frinika.sequencer.model.audio.AudioReader;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JPanel;
import uk.ac.bath.gui.TweakerPanel;
import uk.ac.bath.util.Tweakable;
import uk.ac.bath.util.TweakableInt;
import uk.co.simphoney.audio.Mapper;
import uk.co.simphoney.audio.SpectrumController;
import uk.co.simphoney.audio.dft.FFTSpectrogramControlable;

public class FFTSpectrumController
implements SpectrumController {
    Vector<Tweakable> tweaks = new Vector();
    TweakableInt fftsizeT = new TweakableInt(this.tweaks, 16, 2048, 512, "FFT size");
    TweakableInt chunksizeT = new TweakableInt(this.tweaks, 8, 2048, 256, " chunksize");
    private Mapper freqMapper;
    double maxFreq;
    Observer reco;

    public FFTSpectrumController(final FFTSpectrogramControlable spectroData, final AudioReader reader) {
        this.maxFreq = spectroData.getSampleRate() / 2.0;
        this.freqMapper = new Mapper(){

            public final float eval(float val) {
                return (float)((double)val / FFTSpectrumController.this.maxFreq);
            }
        };
        this.reco = new Observer(){

            public void update(Observable o, Object arg) {
                FFTSpectrumController.this.maxFreq = spectroData.getSampleRate() / 2.0;
                spectroData.setParameters(FFTSpectrumController.this.chunksizeT.intValue(), FFTSpectrumController.this.fftsizeT.intValue(), reader);
            }
        };
        this.fftsizeT.addObserver(this.reco);
        this.chunksizeT.addObserver(this.reco);
    }

    public Mapper getFrequencyMapper() {
        return this.freqMapper;
    }

    public void update() {
        this.reco.update(null, null);
    }

    public JPanel getTweakPanel() {
        TweakerPanel tpanel = new TweakerPanel(2, 4);
        for (Tweakable t : this.tweaks) {
            tpanel.addSpinTweaker(t);
        }
        return tpanel;
    }
}

