/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import uk.ac.bath.gui.TweakerPanel;
import uk.ac.bath.util.Tweakable;
import uk.ac.bath.util.TweakableDouble;
import uk.co.simphoney.audio.BufferedAudioProcess;
import uk.co.simphoney.audio.Mapper;
import uk.co.simphoney.audio.dft.CyclicBufferFFTSpectrogramDataBuilder;
import uk.co.simphoney.audio.gui.CyclicSpectrogrumImage;
import uk.co.simphoney.audio.gui.FFTOption;
import uk.org.toot.audio.core.AudioProcess;

public class CyclicBufferFFTAnalysisPanel
extends JPanel {
    Vector<Tweakable> tweaks = new Vector();
    TweakableDouble mindB = new TweakableDouble(this.tweaks, -400.0, 100.0, -40.0, 5.0, "minDb");
    TweakableDouble maxdB = new TweakableDouble(this.tweaks, -400.0, 100.0, -50.0, 5.0, "maxDb");
    JToggleButton linearBut;
    private static final long serialVersionUID = 1L;
    AudioProcess reader;
    private ValMapper valMapper;
    CyclicSpectrogrumImage image;
    CyclicBufferFFTSpectrogramDataBuilder spectroData;
    JPanel spectroPanel;
    FFTOption[] fftOpts = new FFTOption[]{new FFTOption(512, 256), new FFTOption(512, 128), new FFTOption(1024, 512), new FFTOption(1024, 256), new FFTOption(1024, 128), new FFTOption(2048, 1024), new FFTOption(2048, 512), new FFTOption(2048, 256)};
    private float maxFreq;

    public CyclicBufferFFTAnalysisPanel(JFrame frame, final BufferedAudioProcess bp) {
        this.setLayout(new BorderLayout());
        this.valMapper = new ValMapper();
        this.maxdB.addObserver(this.valMapper);
        this.mindB.addObserver(this.valMapper);
        this.spectroData = new CyclicBufferFFTSpectrogramDataBuilder(bp.out, 1000);
        this.spectroData.setParameters(this.fftOpts[0].chunkSize, this.fftOpts[0].fftSize);
        final JComboBox<FFTOption> combo = new JComboBox<FFTOption>(this.fftOpts);
        combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                final FFTOption opt = (FFTOption)combo.getSelectedItem();
                System.err.println(" xxxxxxxxxxxxxx ");
                new Thread(new Runnable(){

                    public void run() {
                        CyclicBufferFFTAnalysisPanel.this.spectroData.setParameters(opt.chunkSize, opt.fftSize);
                    }
                }).start();
            }
        });
        this.image = new CyclicSpectrogrumImage(this.valMapper, 800);
        this.spectroData.addSizeObserver(this.image);
        this.add((Component)this.image, "Center");
        JPanel buts = new JPanel();
        buts.setLayout(new BoxLayout(buts, 1));
        this.linearBut = new JToggleButton("linear");
        this.linearBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (!CyclicBufferFFTAnalysisPanel.this.linearBut.isSelected()) {
                    CyclicBufferFFTAnalysisPanel.this.linearBut.setText("Linear");
                } else {
                    CyclicBufferFFTAnalysisPanel.this.linearBut.setText("Log10");
                }
                CyclicBufferFFTAnalysisPanel.this.valMapper.update(null, null);
            }
        });
        buts.add(this.linearBut);
        JToggleButton synthBut = new JToggleButton("Synth Mode");
        synthBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
            }
        });
        buts.add(synthBut);
        TweakerPanel tpanel = new TweakerPanel(2, 4);
        for (Tweakable t : this.tweaks) {
            tpanel.addSpinTweaker(t);
        }
        JPanel control = new JPanel();
        control.add(buts);
        control.add(tpanel);
        control.add(combo);
        this.add((Component)control, "South");
        this.valMapper.update(null, null);
        this.revalidate();
        this.repaint();
        final JLabel label = new JLabel("            ");
        control.add(label);
        new Timer(200, new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                label.setText(String.valueOf(bp.getLag()));
            }
        }).start();
    }

    final class ValMapper
    implements Observer,
    Mapper {
        double maxdb;
        double mindb;
        double max;
        double min;
        boolean linear;
        private Thread thread;

        ValMapper() {
        }

        public final float eval(float val) {
            if (this.linear) {
                float vv = (float)(((double)val - this.min) / (this.max - this.min));
                return vv;
            }
            double dB = 20.0 * Math.log10((double)val + 1.0E-15);
            float vv = (float)((dB - this.mindb) / (this.maxdb - this.mindb));
            return vv;
        }

        public void update(Observable o, Object arg) {
            this.linear = CyclicBufferFFTAnalysisPanel.this.linearBut.isSelected();
            this.maxdb = CyclicBufferFFTAnalysisPanel.this.maxdB.doubleValue();
            this.max = Math.pow(10.0, this.maxdb / 20.0);
            this.mindb = CyclicBufferFFTAnalysisPanel.this.mindB.doubleValue();
            this.min = Math.pow(10.0, this.mindb / 20.0);
            CyclicBufferFFTAnalysisPanel.this.repaint();
        }
    }
}

