/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.core;

import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.localisation.Localisation;

public abstract class ChannelFormat {
    public static final ChannelFormat MONO = new ChannelFormat(){
        private int[] empty = new int[0];

        public int getCount() {
            return 1;
        }

        public boolean isCenter(int chan) {
            return true;
        }

        public boolean isLeft(int chan) {
            return false;
        }

        public boolean isRight(int chan) {
            return false;
        }

        public boolean isFront(int chan) {
            return true;
        }

        public boolean isRear(int chan) {
            return false;
        }

        public boolean isLFE(int chan) {
            return false;
        }

        public int getCenter() {
            return 0;
        }

        public int getLFE() {
            return -1;
        }

        public int[] getLeft() {
            return this.empty;
        }

        public int[] getRight() {
            return this.empty;
        }

        public String getName() {
            return Localisation.getString("Mono");
        }

        public String getName(int chan) {
            return Localisation.getString("Centre");
        }
    };
    public static final ChannelFormat STEREO = new ChannelFormat(){
        private int[] left = new int[1];
        private int[] right = new int[]{1};

        public int getCount() {
            return 2;
        }

        public boolean isCenter(int chan) {
            return false;
        }

        public boolean isLeft(int chan) {
            return chan == 0;
        }

        public boolean isRight(int chan) {
            return chan == 1;
        }

        public boolean isFront(int chan) {
            return true;
        }

        public boolean isRear(int chan) {
            return false;
        }

        public boolean isLFE(int chan) {
            return false;
        }

        public int getCenter() {
            return -1;
        }

        public int getLFE() {
            return -1;
        }

        public int[] getLeft() {
            return this.left;
        }

        public int[] getRight() {
            return this.right;
        }

        public String getName() {
            return Localisation.getString("Stereo");
        }

        public String getName(int chan) {
            switch (chan) {
                case 0: {
                    return Localisation.getString("Left");
                }
                case 1: {
                    return Localisation.getString("Right");
                }
            }
            return "illegal channel";
        }
    };
    public static final ChannelFormat QUAD = new ChannelFormat(){
        private int[] left;
        private int[] right;
        {
            int[] nArray = new int[2];
            nArray[1] = 2;
            this.left = nArray;
            this.right = new int[]{1, 3};
        }

        public int getCount() {
            return 4;
        }

        public boolean isCenter(int chan) {
            return false;
        }

        public boolean isLeft(int chan) {
            return (chan & 1) == 0;
        }

        public boolean isRight(int chan) {
            return (chan & 1) == 1;
        }

        public boolean isFront(int chan) {
            return chan < 2;
        }

        public boolean isRear(int chan) {
            return chan >= 2;
        }

        public boolean isLFE(int chan) {
            return false;
        }

        public int getCenter() {
            return -1;
        }

        public int getLFE() {
            return -1;
        }

        public int[] getLeft() {
            return this.left;
        }

        public int[] getRight() {
            return this.right;
        }

        public String getName() {
            return Localisation.getString("Quad");
        }

        public String getName(int chan) {
            switch (chan) {
                case 0: {
                    return Localisation.getString("Front.Left");
                }
                case 1: {
                    return Localisation.getString("Front.Right");
                }
                case 2: {
                    return Localisation.getString("Rear.Left");
                }
                case 3: {
                    return Localisation.getString("Rear Right");
                }
            }
            return "illegal channel";
        }
    };
    public static final ChannelFormat FIVE_1 = new ChannelFormat(){
        private int[] left;
        private int[] right;
        {
            int[] nArray = new int[2];
            nArray[1] = 2;
            this.left = nArray;
            this.right = new int[]{1, 3};
        }

        public int getCount() {
            return 6;
        }

        public boolean isCenter(int chan) {
            return chan == this.getCenter();
        }

        public boolean isLeft(int chan) {
            return chan < 4 && (chan & 1) == 0;
        }

        public boolean isRight(int chan) {
            return chan < 4 && (chan & 1) == 1;
        }

        public boolean isFront(int chan) {
            return chan < 2 || chan == 4;
        }

        public boolean isRear(int chan) {
            return chan >= 2 && chan < 4;
        }

        public boolean isLFE(int chan) {
            return chan == this.getLFE();
        }

        public int getCenter() {
            return 4;
        }

        public int getLFE() {
            return 5;
        }

        public int[] getLeft() {
            return this.left;
        }

        public int[] getRight() {
            return this.right;
        }

        public String getName() {
            return "5.1";
        }

        public String getName(int chan) {
            switch (chan) {
                case 0: {
                    return Localisation.getString("Front.Left");
                }
                case 1: {
                    return Localisation.getString("Front.Right");
                }
                case 2: {
                    return Localisation.getString("Rear.Left");
                }
                case 3: {
                    return Localisation.getString("Rear.Right");
                }
                case 4: {
                    return Localisation.getString("Centre");
                }
                case 5: {
                    return Localisation.getString("LFE");
                }
            }
            return "illegal channel";
        }

        public int mix(AudioBuffer destBuffer, AudioBuffer sourceBuffer, float[] gain) {
            throw new IllegalArgumentException("5.1 mix not implemented!");
        }
    };

    public abstract int getCount();

    public abstract int getCenter();

    public abstract int getLFE();

    public abstract int[] getLeft();

    public abstract int[] getRight();

    public abstract String getName();

    public abstract boolean isCenter(int var1);

    public abstract boolean isLeft(int var1);

    public abstract boolean isRight(int var1);

    public abstract boolean isFront(int var1);

    public abstract boolean isRear(int var1);

    public abstract boolean isLFE(int var1);

    public abstract String getName(int var1);

    public int mix(AudioBuffer destBuffer, AudioBuffer sourceBuffer, float[] gain) {
        boolean doMix = destBuffer != sourceBuffer;
        int snc = sourceBuffer.getChannelCount();
        int dnc = destBuffer.getChannelCount();
        int ns = destBuffer.getSampleCount();
        int i = 0;
        while (i < dnc) {
            int s;
            float g = gain[i];
            float[] in = sourceBuffer.getChannel(i % snc);
            float[] out = destBuffer.getChannel(i);
            if (doMix) {
                s = 0;
                while (s < ns) {
                    int n = s;
                    out[n] = out[n] + in[s] * g;
                    ++s;
                }
            } else {
                s = 0;
                while (s < ns) {
                    out[s] = in[s] * g;
                    ++s;
                }
            }
            ++i;
        }
        int ret = 1;
        if (!doMix) {
            ret |= 2;
        }
        return ret;
    }
}

