/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.delay;

import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioProcess;
import uk.org.toot.audio.core.ChannelFormat;
import uk.org.toot.audio.core.FloatDenormals;
import uk.org.toot.audio.delay.DelayBuffer;
import uk.org.toot.audio.delay.ModulatedDelayVariables;

public class ModulatedDelayProcess
implements AudioProcess {
    private DelayBuffer wetBuffer;
    private DelayBuffer dryBuffer;
    private final ModulatedDelayVariables vars;
    protected int[] modulatorMap;
    protected float modulatorPhase;
    protected ChannelFormat format;
    private boolean wasBypassed;
    private static final float S_B = 1.2732395f;
    private static final float S_C = -0.40528473f;

    public ModulatedDelayProcess(ModulatedDelayVariables vars) {
        this.vars = vars;
        this.modulatorMap = new int[8];
        this.wasBypassed = !vars.isBypassed();
    }

    public void open() {
    }

    public int processAudio(AudioBuffer buffer) {
        float sampleRate = buffer.getSampleRate();
        int ns = buffer.getSampleCount();
        int nc = buffer.getChannelCount();
        if (this.wetBuffer == null) {
            this.wetBuffer = new DelayBuffer(nc, this.msToSamples(this.vars.getMaxDelayMilliseconds(), sampleRate), sampleRate);
        }
        if (this.dryBuffer == null) {
            this.dryBuffer = new DelayBuffer(nc, this.msToSamples(this.vars.getMaxDelayMilliseconds() / 2.0f, sampleRate), sampleRate);
        }
        this.dryBuffer.append(buffer);
        boolean bypassed = this.vars.isBypassed();
        if (bypassed) {
            if (!this.wasBypassed) {
                this.wetBuffer.makeSilence();
                this.wasBypassed = true;
            }
            return 0;
        }
        float depth = this.vars.getDepth();
        float feedback = this.vars.getFeedback();
        float mix = this.vars.getMix();
        float wetMix = this.vars.isWetInverted() ? -mix : mix;
        int staticDelay = (int)this.dryBuffer.msToSamples(this.vars.getDelayMilliseconds());
        this.wetBuffer.conform(buffer);
        ChannelFormat f = buffer.getChannelFormat();
        if (this.format != f) {
            this.format = f;
            this.buildModulatorMap(buffer);
        }
        float timeDelta = 1.0f / sampleRate;
        float scaledDepth = (float)staticDelay * depth;
        int s = 0;
        while (s < ns) {
            this.incrementModulators(timeDelta);
            int ch = 0;
            while (ch < nc) {
                float[] buf = buffer.getChannel(ch);
                float modulatedDelay = this.modulation(ch) * scaledDepth;
                float out = this.wetBuffer.out(ch, (float)staticDelay + modulatedDelay);
                if (FloatDenormals.isDenormal(out)) {
                    out = 0.0f;
                }
                float fb = feedback * out;
                float in = buf[s];
                if (FloatDenormals.isDenormal(in)) {
                    in = 0.0f;
                }
                this.wetBuffer.append(ch, in + fb);
                buf[s] = out * wetMix;
                ++ch;
            }
            this.wetBuffer.nudge(1);
            ++s;
        }
        this.dryBuffer.tap(buffer, this.vars.isTape() ? staticDelay : 0, 1.0f - mix);
        this.wasBypassed = bypassed;
        return 0;
    }

    public void close() {
        this.wetBuffer = null;
        this.dryBuffer = null;
    }

    protected void buildModulatorMap(AudioBuffer buffer) {
        int nc = buffer.getChannelCount();
        int ch = 0;
        while (ch < nc) {
            this.modulatorMap[ch] = this.format.isLFE(ch) ? -1 : 0;
            ++ch;
        }
    }

    protected void incrementModulators(float timeDelta) {
        double phaseDelta = (double)(timeDelta * this.vars.getRate() * 2.0f) * Math.PI;
        this.modulatorPhase = (float)((double)this.modulatorPhase + phaseDelta);
        if ((double)this.modulatorPhase > Math.PI) {
            this.modulatorPhase = (float)((double)this.modulatorPhase - Math.PI * 2);
        }
    }

    protected float modulation(int chan) {
        float mod;
        if (this.modulatorMap[chan] < 0) {
            return 0.0f;
        }
        int shape = this.vars.getLFOShape();
        float f = mod = shape == 0 ? this.sine(this.modulatorPhase) : this.triangle(this.modulatorPhase);
        if (mod < -1.0f) {
            mod = -1.0f;
        } else if (mod > 1.0f) {
            mod = 1.0f;
        }
        return mod;
    }

    protected float sine(float x) {
        return 1.2732395f * x + -0.40528473f * x * Math.abs(x);
    }

    protected float triangle(float x) {
        x = (float)((double)x + Math.PI);
        x = (float)((double)x / 1.5707963267948966);
        if ((x -= 1.0f) > 1.0f) {
            x -= 4.0f;
        }
        return Math.abs(-(Math.abs(x) - 2.0f)) - 1.0f;
    }

    protected int msToSamples(float ms, float sr) {
        return Math.round(ms * sr / 1000.0f);
    }
}

