/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.dynamics;

import java.awt.Color;
import uk.org.toot.audio.core.AudioControls;
import uk.org.toot.audio.dynamics.DynamicsDesign;
import uk.org.toot.control.CompoundControl;
import uk.org.toot.control.FloatControl;
import uk.org.toot.control.LinearLaw;
import uk.org.toot.control.LogLaw;
import uk.org.toot.localisation.Localisation;

public abstract class DynamicsControls
extends AudioControls
implements DynamicsDesign.DesignVariables {
    private GainReductionIndicator gainReductionIndicator;
    private FloatControl thresholdControl;
    private FloatControl ratioControl;
    private FloatControl kneeControl;
    private FloatControl attackControl;
    private FloatControl holdControl;
    private FloatControl releaseControl;
    private FloatControl gainControl;
    private FloatControl depthControl;
    private float kneedB = 0.0f;
    private int idOffset = 0;

    public DynamicsControls(int id, String name) {
        this(id, name, 0);
    }

    public DynamicsControls(int id, String name, int idOffset) {
        super(id, name, 126 - idOffset);
        this.idOffset = idOffset;
        if (this.hasGainReductionIndicator()) {
            this.gainReductionIndicator = new GainReductionIndicator();
            this.add(this.gainReductionIndicator);
        }
        CompoundControl.ControlColumn g1 = new CompoundControl.ControlColumn();
        if (this.hasDepth()) {
            this.depthControl = this.createDepthControl(-80.0f);
            g1.add(this.depthControl);
        }
        if (this.hasRatio()) {
            if (this.kneedB > 0.0f) {
                this.kneeControl = this.createKneeControl(this.kneedB);
                g1.add(this.kneeControl);
            }
            this.ratioControl = this.createRatioControl();
            g1.add(this.ratioControl);
        }
        this.thresholdControl = this.createThresholdControl(this.getMinimumThreshold());
        g1.add(this.thresholdControl);
        this.add(g1);
        CompoundControl.ControlColumn g2 = new CompoundControl.ControlColumn();
        this.attackControl = this.createAttackControl(0.1f, 100.0f, 1.0f);
        g2.add(this.attackControl);
        if (this.hasHold()) {
            this.holdControl = this.createHoldControl(0.0f, 1000.0f, 10.0f);
            g2.add(this.holdControl);
        }
        this.releaseControl = this.createReleaseControl(2.0f, 2000.0f, 200.0f);
        g2.add(this.releaseControl);
        this.add(g2);
        CompoundControl.ControlColumn g3 = new CompoundControl.ControlColumn();
        boolean useg3 = false;
        if (this.hasGain()) {
            this.gainControl = this.createGainControl(-12.0f, 12.0f);
            g3.add(this.gainControl);
            useg3 = true;
        }
        if (useg3) {
            this.add(g3);
        }
    }

    public boolean canBypass() {
        return true;
    }

    protected boolean hasGainReductionIndicator() {
        return false;
    }

    protected float getMinimumThreshold() {
        return -40.0f;
    }

    protected FloatControl createThresholdControl(float min) {
        LinearLaw law = new LinearLaw(min, 20.0f, "dB");
        FloatControl threshold = new FloatControl(1 + this.idOffset, Localisation.getString("Threshold"), law, 0.1f, 0.0f);
        threshold.setInsertColor(Color.white);
        return threshold;
    }

    protected boolean hasRatio() {
        return false;
    }

    protected FloatControl createRatioControl() {
        LogLaw law = new LogLaw(1.0f, 10.0f, "");
        FloatControl ratio = new FloatControl(2 + this.idOffset, Localisation.getString("Ratio"), law, 0.1f, 2.0f);
        ratio.setInsertColor(Color.magenta.darker());
        return ratio;
    }

    protected FloatControl createKneeControl(float kneedB) {
        LinearLaw law = new LinearLaw(0.0f, kneedB, "dB");
        FloatControl knee = new FloatControl(3 + this.idOffset, Localisation.getString("Knee"), law, 0.1f, kneedB / 2.0f);
        return knee;
    }

    protected FloatControl createAttackControl(float min, float max, float init) {
        LogLaw law = new LogLaw(min, max, "ms");
        FloatControl attack = new FloatControl(4 + this.idOffset, Localisation.getString("Attack"), law, 0.1f, init);
        attack.setInsertColor(Color.red.darker());
        return attack;
    }

    protected boolean hasHold() {
        return false;
    }

    protected FloatControl createHoldControl(float min, float max, float init) {
        LinearLaw law = new LinearLaw(min, max, "ms");
        FloatControl hold = new FloatControl(5 + this.idOffset, Localisation.getString("Hold"), law, 1.0f, init);
        hold.setInsertColor(Color.red.darker());
        return hold;
    }

    protected FloatControl createReleaseControl(float min, float max, float init) {
        LogLaw law = new LogLaw(min, max, "ms");
        FloatControl release = new FloatControl(6 + this.idOffset, Localisation.getString("Release"), law, 1.0f, init);
        release.setInsertColor(Color.red.darker());
        return release;
    }

    protected boolean hasGain() {
        return false;
    }

    protected FloatControl createGainControl(float min, float max) {
        LinearLaw law = new LinearLaw(min, max, "dB");
        FloatControl gain = new FloatControl(7 + this.idOffset, Localisation.getString("Gain"), law, 1.0f, 0.0f);
        gain.setInsertColor(Color.white);
        return gain;
    }

    protected boolean hasDepth() {
        return false;
    }

    protected FloatControl createDepthControl(float depth) {
        LinearLaw law = new LinearLaw(depth, 0.0f, "dB");
        FloatControl depthC = new FloatControl(9 + this.idOffset, Localisation.getString("Depth"), law, 1.0f, -40.0f);
        depthC.setInsertColor(Color.lightGray);
        return depthC;
    }

    public float getThresholddB() {
        return this.thresholdControl.getValue();
    }

    public float getRatio() {
        if (this.ratioControl == null) {
            return 1.0f;
        }
        return this.ratioControl.getValue();
    }

    public float getKneedB() {
        if (this.kneeControl == null) {
            return 0.0f;
        }
        return this.kneeControl.getValue();
    }

    public float getAttackMilliseconds() {
        return this.attackControl.getValue();
    }

    public float getHoldMilliseconds() {
        if (this.holdControl == null) {
            return 0.0f;
        }
        return this.holdControl.getValue();
    }

    public float getReleaseMilliseconds() {
        if (this.releaseControl == null) {
            return 0.0f;
        }
        return this.releaseControl.getValue();
    }

    public float getGaindB() {
        if (this.gainControl == null) {
            return 0.0f;
        }
        return this.gainControl.getValue();
    }

    public float getDepthdB() {
        if (this.depthControl == null) {
            return 40.0f;
        }
        return this.depthControl.getValue();
    }

    public void setGainReduction(float dB) {
        if (this.gainReductionIndicator == null) {
            return;
        }
        this.gainReductionIndicator.setValue(dB);
    }

    protected static class GainReductionIndicator
    extends FloatControl {
        public GainReductionIndicator() {
            super(0, "Gain Reduction", new LinearLaw(-20.0f, 0.0f, "dB"), 3.0f, 0.0f);
            this.indicator = true;
            this.setHidden(true);
        }
    }
}

