/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.dynamics;

import uk.org.toot.audio.core.AudioControls;
import uk.org.toot.audio.core.AudioProcess;
import uk.org.toot.audio.dynamics.Compressor;
import uk.org.toot.audio.dynamics.DynamicsControls;
import uk.org.toot.audio.dynamics.DynamicsDesign;
import uk.org.toot.audio.dynamics.Expander;
import uk.org.toot.audio.dynamics.Gate;
import uk.org.toot.audio.dynamics.Limiter;
import uk.org.toot.audio.dynamics.MultiBandCompressor;
import uk.org.toot.audio.spi.TootAudioServiceProvider;
import uk.org.toot.localisation.Localisation;

public class DynamicsServiceProvider
extends TootAudioServiceProvider {
    public DynamicsServiceProvider() {
        super(Localisation.getString("Dynamics"), "0.1");
        String family = this.description;
        this.addControls(Compressor.Controls.class, 34, Localisation.getString("Compressor"), family, "0.1");
        this.addControls(Limiter.Controls.class, 33, Localisation.getString("Limiter"), family, "0.1");
        this.addControls(Gate.Controls.class, 36, Localisation.getString("Gate"), family, "0.1");
        this.addControls(MultiBandCompressor.DualBandControls.class, 38, Localisation.getString("Dual.Band.Compressor"), family, "0.1");
        this.add(Compressor.class, Localisation.getString("Compressor"), family, "0.1");
        this.add(Limiter.class, Localisation.getString("Limiter"), family, "0.1");
        this.add(Gate.class, Localisation.getString("Gate"), family, "0.1");
        this.add(MultiBandCompressor.class, Localisation.getString("Multi.Band.Compressor"), family, "0.1");
    }

    public AudioProcess createProcessor(AudioControls c) {
        if (c instanceof MultiBandCompressor.MultiBandControls) {
            return new MultiBandCompressor((MultiBandCompressor.MultiBandControls)c);
        }
        if (!(c instanceof DynamicsControls)) {
            return null;
        }
        if (c instanceof Compressor.Controls) {
            return new Compressor(new DynamicsDesign((Compressor.Controls)c));
        }
        if (c instanceof Limiter.Controls) {
            return new Limiter(new DynamicsDesign((Limiter.Controls)c));
        }
        if (c instanceof Expander.Controls) {
            return new Expander(new DynamicsDesign((Expander.Controls)c));
        }
        if (c instanceof Gate.Controls) {
            return new Gate(new DynamicsDesign((Gate.Controls)c));
        }
        return null;
    }
}

