/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.eq;

import java.awt.Color;
import java.util.List;
import uk.org.toot.audio.core.AudioControls;
import uk.org.toot.audio.eq.GraphicEQ;
import uk.org.toot.audio.filter.Filter;
import uk.org.toot.audio.filter.FilterSpecification;
import uk.org.toot.control.EnumControl;
import uk.org.toot.control.FloatControl;
import uk.org.toot.control.LinearLaw;
import uk.org.toot.control.LogLaw;
import uk.org.toot.localisation.Localisation;

public class ClassicFilterControls
extends AudioControls
implements FilterSpecification {
    private Filter.Type type;
    private FloatControl leveldB;
    private FloatControl freq;
    private FloatControl res;

    public ClassicFilterControls(String name, int id, Filter.Type typevalue, boolean typefixed, float fmin, float fmax, float fvalue, boolean ffixed, float qmin, float qmax, float qvalue, boolean qfixed, float dBmin, float dBmax, float dBvalue, boolean dBfixed) {
        super(0, name);
        this.type = typevalue;
        this.res = this.createResonanceControl(id + 2, qmin, qmax, qvalue, qfixed);
        this.add(this.res);
        this.freq = this.createFrequencyControl(id + 1, fmin, fmax, fvalue, ffixed);
        this.add(this.freq);
        this.leveldB = this.createLevelControl(id, dBmin, dBmax, dBvalue, dBfixed);
        this.add(this.leveldB);
    }

    public ClassicFilterControls(String name, int id, Filter.Type typevalue, float freq, float q, float leveldB) {
        this(name, id, typevalue, true, 40.0f, 20000.0f, freq, false, 0.5f, 5.0f, q, q > 1.05f, -15.0f, 15.0f, leveldB, false);
    }

    public boolean isAlwaysVertical() {
        return true;
    }

    public Filter.Type getClassicType() {
        return this.type;
    }

    public int getFrequency() {
        return (int)this.freq.getValue();
    }

    public void setFrequency(int frequency) {
        this.freq.setValue(frequency);
    }

    public float getResonance() {
        return this.res.getValue();
    }

    public void setResonance(float q) {
        this.res.setValue(q);
    }

    public void setLeveldB(float dBlevel) {
        this.leveldB.setValue(dBlevel);
    }

    public float getLeveldB() {
        return this.leveldB.getValue();
    }

    public float getLevelFactor() {
        return (float)Math.pow(10.0, (double)this.getLeveldB() / 20.0);
    }

    protected FloatControl createFrequencyControl(int id, float min, float max, float initial, boolean fixed) {
        LogLaw law = new LogLaw(min, max, "Hz");
        FloatControl freq = new FloatControl(id, Localisation.getString("Frequency"), law, 1.0f, initial);
        freq.setInsertColor(Color.yellow);
        freq.setHidden(fixed);
        return freq;
    }

    protected FloatControl createLevelControl(int id, float min, float max, float initial, boolean fixed) {
        LinearLaw law = new LinearLaw(min, max, "dB");
        FloatControl lev = new FloatControl(id, Localisation.getString("Level"), law, 0.1f, initial){
            private String[] presetNames;
            {
                this.presetNames = new String[]{Localisation.getString("Flat")};
            }

            public boolean isRotary() {
                return !(this.getParent().getParent() instanceof GraphicEQ.Controls);
            }

            public String[] getPresetNames() {
                return this.presetNames;
            }

            public void applyPreset(String name) {
                if (Localisation.getString("Flat").equals(name)) {
                    this.setValue(0.0f);
                }
            }
        };
        lev.setInsertColor(Color.white);
        lev.setHidden(fixed);
        return lev;
    }

    protected FloatControl createResonanceControl(int id, float min, float max, float initial, boolean fixed) {
        LogLaw law = new LogLaw(min, max, "");
        FloatControl lev = new FloatControl(id, Localisation.getString("Resonance"), law, 0.1f, initial);
        lev.setInsertColor(Color.orange);
        lev.setHidden(fixed);
        return lev;
    }

    public static class TypeControl
    extends EnumControl {
        public TypeControl(int id, Object value, boolean fixed) {
            super(id, "Type", value);
            this.setHidden(fixed);
        }

        public List getValues() {
            return null;
        }
    }
}

