/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.filter;

import uk.org.toot.audio.filter.AbstractFilter;
import uk.org.toot.audio.filter.FIRDesign;
import uk.org.toot.audio.filter.Filter;
import uk.org.toot.audio.filter.FilterDesign;
import uk.org.toot.audio.filter.FilterSpecification;

public class FIRFilter
extends AbstractFilter {
    private float[] a;

    public FIRFilter(FilterSpecification spec) {
        super(spec);
    }

    public float filterSample(float sample, FIRState s) {
        float y = 0.0f;
        int taps = this.a.length;
        s.x[0] = sample;
        int k = 0;
        while (k < taps) {
            y += this.a[k] * s.x[k];
            ++k;
        }
        k = taps - 1;
        while (k > 0) {
            s.x[k] = s.x[k - 1];
            --k;
        }
        return y;
    }

    public void filter(float[] signal, float[] mixBuffer, int len, int chan, boolean doMix) {
        FIRState s = (FIRState)this.getState(chan);
        int i = 0;
        while (i < len) {
            float y = this.filterSample(signal[i], s);
            if (doMix) {
                int n = i;
                mixBuffer[n] = mixBuffer[n] + this.amplitudeAdj * y;
            } else {
                mixBuffer[i] = y;
            }
            ++i;
        }
    }

    protected void updateFilterCoefficients() {
        float[] coeffs = ((FIRDesign)this.getDesign()).getCoefficients();
        if (this.a.length != coeffs.length) {
            this.a = new float[coeffs.length];
        }
        System.arraycopy(coeffs, 0, this.a, 0, this.a.length);
    }

    protected FilterDesign createDesign(FilterSpecification spec) {
        return new FIRDesign(spec);
    }

    protected Filter.State createState() {
        return new FIRState();
    }

    private class FIRState
    implements Filter.State {
        public float[] x;

        public FIRState() {
            this.x = new float[FIRFilter.this.a.length];
        }

        public void clear() {
            int i = 0;
            while (i < this.x.length) {
                this.x[i] = 0.0f;
                ++i;
            }
        }
    }
}

