/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.mixer;

import java.util.ArrayList;
import java.util.List;
import uk.org.toot.audio.core.AudioControlsChain;
import uk.org.toot.audio.mixer.BusControls;
import uk.org.toot.audio.mixer.MainMixVariables;
import uk.org.toot.audio.mixer.MixControls;
import uk.org.toot.audio.mixer.MixerControls;
import uk.org.toot.control.Control;
import uk.org.toot.control.EnumControl;
import uk.org.toot.localisation.Localisation;

public class MainMixControls
extends MixControls
implements MainMixVariables {
    private EnumControl routeControl;

    public MainMixControls(MixerControls mixerControls, int stripId, BusControls busControls, boolean isMaster) {
        super(mixerControls, stripId, busControls, isMaster);
    }

    protected EnumControl createRouteControl(int stripId) {
        if (stripId != 123 && stripId != 124) {
            this.routeControl = new RouteControl(this.mixerControls.getControls().get(0).getName(), stripId == 120);
            return this.routeControl;
        }
        return null;
    }

    public EnumControl getRouteControl() {
        return this.routeControl;
    }

    protected class RouteControl
    extends EnumControl {
        private boolean canRouteToGroups;

        public RouteControl(String defaultRoute, boolean canRouteToGroups) {
            super(4, Localisation.getString("Route"), defaultRoute);
            this.canRouteToGroups = true;
            this.canRouteToGroups = canRouteToGroups;
            this.indicator = !canRouteToGroups;
        }

        public List getValues() {
            ArrayList<String> values = new ArrayList<String>();
            for (Control control : MainMixControls.this.mixerControls.getControls()) {
                if (!(control instanceof AudioControlsChain) || control.getId() != 123 && (control.getId() != 121 || !this.canRouteToGroups)) continue;
                values.add(control.getName());
            }
            return values;
        }
    }
}

