/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.mixer.automation;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import uk.org.toot.audio.core.AudioControlsChain;
import uk.org.toot.audio.mixer.MixerControls;
import uk.org.toot.audio.mixer.automation.MixerControlsConciseDynamicAutomation;
import uk.org.toot.control.Control;
import uk.org.toot.control.ControlSysexMsg;

public abstract class MixerControlsMidiDynamicAutomation
extends MixerControlsConciseDynamicAutomation {
    public MixerControlsMidiDynamicAutomation(MixerControls controls) {
        super(controls);
    }

    protected Control findControl(String name, MidiMessage msg) {
        if (!ControlSysexMsg.isControl(msg)) {
            return null;
        }
        AudioControlsChain strip = this.getStrip(name);
        if (strip == null) {
            return null;
        }
        return this.findControl(strip, ControlSysexMsg.getProviderId(msg), ControlSysexMsg.getModuleId(msg), ControlSysexMsg.getInstanceIndex(msg), ControlSysexMsg.getControlId(msg));
    }

    protected void read(String name, MidiMessage msg) {
        if (!ControlSysexMsg.isControl(msg)) {
            return;
        }
        this.read(name, ControlSysexMsg.getProviderId(msg), ControlSysexMsg.getModuleId(msg), ControlSysexMsg.getInstanceIndex(msg), ControlSysexMsg.getControlId(msg), ControlSysexMsg.getValue(msg));
    }

    protected void write(String name, int providerId, int moduleId, int instanceIndex, int controlId, int value) {
        try {
            MidiMessage msg = ControlSysexMsg.createControl(providerId, moduleId, instanceIndex, controlId, value);
            this.write(name, msg);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    protected abstract void write(String var1, MidiMessage var2);
}

