/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.mixer.automation;

import java.io.File;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import uk.org.toot.audio.mixer.MixerControls;
import uk.org.toot.audio.mixer.MixerControlsSnapshotAutomation;
import uk.org.toot.audio.mixer.automation.MixerControlsMidiSequenceSnapshotAutomation;

public class MixerControlsMidiFileSnapshotAutomation
extends MixerControlsMidiSequenceSnapshotAutomation
implements MixerControlsSnapshotAutomation {
    protected File snapshotPath;
    public static final String SNAPSHOT_DIR = "snapshots";
    public static final String SNAPSHOT_EXT = ".snapshot";

    public MixerControlsMidiFileSnapshotAutomation(MixerControls controls, File path) {
        super(controls);
        this.snapshotPath = path;
    }

    public void configure(String name) {
        File file = this.getSnapshotFile(name);
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        try {
            this.configureSequence(MidiSystem.getSequence(file));
        }
        catch (InvalidMidiDataException imde) {
            System.err.println("Failed to configure Snapshot " + name);
        }
        catch (IOException ioe) {
            System.err.println("Failed to congigure or read Snapshot file " + file.getPath());
        }
    }

    public void recall(String name) {
        File file = this.getSnapshotFile(name);
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        try {
            this.recallSequence(MidiSystem.getSequence(file));
        }
        catch (InvalidMidiDataException imde) {
            System.err.println("Failed to recall Snapshot " + name);
        }
        catch (IOException ioe) {
            System.err.println("Failed to read Snapshot file " + file.getPath());
        }
    }

    public void store(String name) {
        File file = this.getSnapshotFile(name);
        if (file == null) {
            return;
        }
        if (file.exists()) {
            file.delete();
        }
        Sequence snapshot = null;
        try {
            snapshot = this.storeSequence(name);
            file.createNewFile();
            MidiSystem.write(snapshot, 1, file);
        }
        catch (IOException ioe) {
            System.err.println("Failed to create or write Snapshot file " + file.getPath());
        }
    }

    public String[] list() {
        if (this.snapshotPath == null) {
            return null;
        }
        return this.snapshotPath.list();
    }

    protected File getSnapshotFile(String name) {
        if (this.snapshotPath == null) {
            return null;
        }
        return new File(this.snapshotPath, String.valueOf(name) + SNAPSHOT_EXT);
    }
}

