/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.control;

import java.util.Collections;
import java.util.List;
import uk.org.toot.control.CompoundControl;
import uk.org.toot.control.Control;
import uk.org.toot.service.ServiceDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundControlChain
extends CompoundControl {
    public CompoundControlChain(int id, String name) {
        super(id, name);
    }

    public CompoundControlChain(int id, int index, String name) {
        super(id, index, name);
    }

    public void add(CompoundControl control) {
        if (this.find(control.getName()) != null) {
            this.disambiguate(control);
        }
        super.add(control);
    }

    public void add(int index, CompoundControl control) {
        if (this.controls == null) {
            return;
        }
        this.controls.add(index, control);
        control.parent = this;
    }

    public void insert(String insertName, String insertBeforeName) {
        CompoundControl controlToInsert = this.createControl(insertName);
        if (controlToInsert == null) {
            System.err.println(String.valueOf(this.getName()) + ": insert failed to create " + insertName);
            return;
        }
        if (this.find(insertName) != null) {
            this.disambiguate(controlToInsert);
        }
        int insertionIndex = this.controls.size();
        if (insertBeforeName != null) {
            CompoundControl controlToInsertBefore = (CompoundControl)this.find(insertBeforeName);
            if (controlToInsertBefore == null) {
                System.err.println(String.valueOf(this.getName()) + ": insert " + insertName + ", " + insertBeforeName + " not found to insert before");
                return;
            }
            if (!controlToInsertBefore.canBeInsertedBefore()) {
                System.err.println(String.valueOf(this.getName()) + ": insert " + insertName + " before " + insertBeforeName + " not allowed");
                return;
            }
            insertionIndex = this.controls.indexOf(controlToInsertBefore);
        }
        this.controls.add(insertionIndex, controlToInsert);
        controlToInsert.parent = this;
        this.setChanged();
        this.notifyObservers(new ChainMutation(2, insertionIndex));
    }

    protected void disambiguate(CompoundControl c) {
        String str;
        String original = c.getName();
        int index = 2;
        do {
            str = String.valueOf(original) + " #" + index;
            ++index;
        } while (this.find(str) != null);
        c.setName(str);
        c.instanceIndex = --index;
        assert (index < 8);
    }

    protected CompoundControl createControl(String name) {
        return null;
    }

    public List<ServiceDescriptor> descriptors() {
        return Collections.emptyList();
    }

    public void delete(String deleteName) {
        Control controlToDelete = this.find(deleteName);
        if (controlToDelete == null) {
            return;
        }
        this.delete(this.controls.indexOf(controlToDelete));
    }

    public void delete(int indexToDelete) {
        this.controls.remove(indexToDelete);
        this.setChanged();
        this.notifyObservers(new ChainMutation(1, indexToDelete));
    }

    public void move(String moveName, String moveBeforeName) {
        Control controlToMove = this.find(moveName);
        Control controlToMoveBefore = this.find(moveBeforeName);
        if (controlToMove == null || controlToMoveBefore == null) {
            return;
        }
        int indexToMove = this.controls.indexOf(controlToMove);
        this.controls.remove(indexToMove);
        int insertionIndex = this.controls.indexOf(controlToMoveBefore);
        this.controls.add(insertionIndex, controlToMove);
        this.setChanged();
        this.notifyObservers(new ChainMutation(3, indexToMove, insertionIndex));
    }

    public void setMutating(boolean mutating) {
        this.setChanged();
        this.notifyObservers(mutating ? ChainMutation.COMMENCE_INSTANCE : ChainMutation.COMPLETE_INSTANCE);
    }

    public static class ChainMutation {
        public static final int DELETE = 1;
        public static final int INSERT = 2;
        public static final int MOVE = 3;
        public static final int COMMENCE = 4;
        public static final int COMPLETE = 5;
        public static final ChainMutation COMMENCE_INSTANCE = new ChainMutation(4);
        public static final ChainMutation COMPLETE_INSTANCE = new ChainMutation(5);
        private int type;
        private int index0 = -1;
        private int index1 = -1;

        public ChainMutation(int type) {
            if (type != 4 && type != 5) {
                throw new IllegalArgumentException("illegal no indices costructor for this type");
            }
            this.type = type;
        }

        public ChainMutation(int type, int index) {
            this.type = type;
            this.index0 = index;
        }

        public ChainMutation(int type, int index0, int index1) {
            this(type, index0);
            this.index1 = index1;
        }

        public int getType() {
            return this.type;
        }

        public int getIndex0() {
            return this.index0;
        }

        public int getIndex1() {
            return this.index1;
        }

        public String toString() {
            return String.valueOf(this.typeName()) + "(" + this.index0 + ", " + this.index1 + ")";
        }

        private String typeName() {
            switch (this.type) {
                case 1: {
                    return "Delete";
                }
                case 2: {
                    return "Insert";
                }
                case 3: {
                    return "Move";
                }
                case 4: {
                    return "Commence";
                }
                case 5: {
                    return "Complete";
                }
            }
            return "unknown mutation";
        }
    }
}

