/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.control;

import java.util.Observable;
import uk.org.toot.control.CompoundControl;

public abstract class Control
extends Observable {
    private final int id;
    CompoundControl parent = null;
    private String name;
    private String annotation;
    private boolean hidden = false;
    protected boolean indicator = false;
    private boolean adjusting = false;

    protected Control(int id, String name) {
        this.checkId(id);
        this.id = id;
        this.name = name;
        this.annotation = name;
    }

    protected void checkId(int id) {
        if (id > 127) {
            throw new IllegalArgumentException(String.valueOf(this.name) + " id " + id + " > 127!");
        }
    }

    public void setHidden(boolean h) {
        this.hidden = h;
    }

    public int getId() {
        return this.id;
    }

    public CompoundControl getParent() {
        return this.parent;
    }

    protected void notifyParent(Control obj) {
        this.setChanged();
        this.notifyObservers(obj);
        if (obj.isIndicator()) {
            return;
        }
        if (this.parent != null) {
            this.parent.notifyParent(obj);
        }
    }

    public String getName() {
        return this.name;
    }

    void setName(String s) {
        this.name = s;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String a) {
        this.annotation = a;
    }

    public void setIntValue(int value) {
        System.err.println("Unexpected setIntValue(" + value + ") called on " + this.getControlPath());
    }

    public int getIntValue() {
        return -1;
    }

    public String getValueString() {
        return "";
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isIndicator() {
        return this.indicator;
    }

    public boolean isAdjusting() {
        return this.adjusting;
    }

    public void setAdjusting(boolean state) {
        this.adjusting = state;
        this.notifyParent(this);
    }

    public String toString() {
        return String.valueOf(this.getName()) + " Control";
    }

    public String getControlPath() {
        return this.getControlPath(null, "/");
    }

    public String getControlPath(Control from, String sep) {
        if (this.parent != from) {
            if (this.getName().length() > 0) {
                return String.valueOf(this.parent.getControlPath(from, sep)) + sep + this.getName();
            }
            return this.parent.getControlPath(from, sep);
        }
        return this.getName();
    }
}

