/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midi.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import uk.org.toot.midi.core.MidiDevice;
import uk.org.toot.midi.core.MidiInput;
import uk.org.toot.midi.core.MidiOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractMidiDevice
extends Observable
implements MidiDevice {
    protected List<MidiInput> inputs;
    protected List<MidiOutput> outputs;
    private String name;

    public AbstractMidiDevice(String name) {
        this.name = name;
        this.inputs = new ArrayList<MidiInput>();
        this.outputs = new ArrayList<MidiOutput>();
    }

    @Override
    public List<MidiInput> getMidiInputs() {
        return Collections.unmodifiableList(this.inputs);
    }

    @Override
    public List<MidiOutput> getMidiOutputs() {
        return Collections.unmodifiableList(this.outputs);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void addMidiInput(MidiInput input) {
        this.inputs.add(input);
        this.setChanged();
        this.notifyObservers();
    }

    protected void removeMidiInput(MidiInput input) {
        this.inputs.remove(input);
        this.setChanged();
        this.notifyObservers();
    }

    protected void removeAllMidiInputs() {
        this.inputs.clear();
        this.setChanged();
        this.notifyObservers();
    }

    protected void addMidiOutput(MidiOutput output) {
        this.outputs.add(output);
        this.setChanged();
        this.notifyObservers();
    }

    protected void removeMidiOutput(MidiOutput output) {
        this.outputs.remove(output);
        this.setChanged();
        this.notifyObservers();
    }

    protected void removeAllMidiOutputs() {
        this.outputs.clear();
        this.setChanged();
        this.notifyObservers();
    }
}

