/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midi.core.channel;

import uk.org.toot.midi.core.channel.MidiChannelReader;
import uk.org.toot.midi.misc.Controller;

public class DefaultMidiChannelReader
implements MidiChannelReader {
    private int index;
    private boolean solo = false;
    private boolean mute = false;
    private boolean omni = false;
    private boolean mono = false;
    private int pitchBend = 0;
    private int program = 0;
    private int channelPressure = 0;
    private int[] polyPressure = new int[128];
    private int[] control = new int[128];

    public DefaultMidiChannelReader(int index) {
        this.index = index;
    }

    public void decode(int command, int data1, int data2) {
        switch (command) {
            case 176: {
                this.decodeControlChange(data1, data2);
                break;
            }
            case 192: {
                this.decodeProgramChange(data1);
                break;
            }
            case 208: {
                this.decodeChannelPressure(data1);
                break;
            }
            case 160: {
                this.decodePolyPressure(data1, data2);
                break;
            }
            case 224: {
                this.decodePitchBend(data1, data2);
            }
        }
    }

    private int getPseudoControl(int control) {
        switch (control) {
            case -224: {
                return this.getPitchBend();
            }
            case -160: {
                return 0;
            }
            case -208: {
                return this.getChannelPressure();
            }
            case -192: {
                return this.getProgram();
            }
        }
        return 0;
    }

    public int getControl(int control) {
        if (control < 0) {
            return this.getPseudoControl(control);
        }
        if (Controller.is7bit(control)) {
            return this.getController(control);
        }
        int msb = this.getController(control &= 0x1F);
        int lsb = 0;
        return 128 * msb + lsb;
    }

    public int getPolyPressure(int noteNumber) {
        return this.polyPressure[noteNumber];
    }

    protected void decodePolyPressure(int note, int pressure) {
        this.polyPressure[note] = pressure;
    }

    protected void decodeChannelPressure(int pressure) {
        this.channelPressure = pressure;
    }

    public int getChannelPressure() {
        return this.channelPressure;
    }

    protected void decodeControlChange(int controller, int value) {
        if (controller < 0 || controller > 127) {
            return;
        }
        this.control[controller] = value;
        if (controller < 32) {
            this.control[controller + 32] = 0;
        }
    }

    public int getController(int controller) {
        return this.control[controller];
    }

    protected void decodeProgramChange(int program) {
        this.program = program;
    }

    public int getProgram() {
        return this.program;
    }

    protected void decodePitchBend(int data1, int data2) {
        int bend;
        this.pitchBend = bend = data2 << 7 | data1 & 0x3F;
    }

    public int getPitchBend() {
        return this.pitchBend;
    }

    public int getVolume() {
        return this.getControl(7);
    }

    public int getPan() {
        return this.getControl(10);
    }

    public boolean getMono() {
        return this.mono;
    }

    public boolean getOmni() {
        return this.omni;
    }

    public boolean getMute() {
        return this.mute;
    }

    public boolean getSolo() {
        return this.solo;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

