/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midi.message;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import uk.org.toot.midi.message.PitchMsg;

public class NoteMsg
extends PitchMsg {
    private static int noteOff = 144;

    public static boolean isNote(MidiMessage msg) {
        return NoteMsg.isNote(NoteMsg.getStatus(msg));
    }

    public static boolean isNote(int status) {
        int cmd = NoteMsg.getCommand(status);
        return cmd == 144 || cmd == 128;
    }

    public static MidiMessage on(int chan, int note, int vel) throws InvalidMidiDataException {
        return NoteMsg.createChannel(144, chan, note, vel);
    }

    public static MidiMessage off(int chan, int note, int vel) throws InvalidMidiDataException {
        return NoteMsg.createChannel(128, chan, note, vel);
    }

    public static MidiMessage off(int chan, int note) throws InvalidMidiDataException {
        return NoteMsg.createChannel(noteOff, chan, note, 0);
    }

    public static boolean isOn(MidiMessage msg) {
        return NoteMsg.isOn(NoteMsg.getStatus(msg), NoteMsg.getVelocity(msg));
    }

    public static boolean isOn(int status, int data2) {
        return NoteMsg.getCommand(status) == 144 && data2 != 0;
    }

    public static boolean isOff(MidiMessage msg) {
        return NoteMsg.isOff(NoteMsg.getStatus(msg), NoteMsg.getVelocity(msg));
    }

    public static boolean isOff(int status, int data2) {
        return !NoteMsg.isOn(status, data2);
    }

    public static int getVelocity(MidiMessage msg) {
        return NoteMsg.getData2(msg);
    }

    public static MidiMessage setVelocity(MidiMessage msg, int vel) throws InvalidMidiDataException {
        return NoteMsg.setData2(msg, vel);
    }

    public static MidiMessage louden(MidiMessage msg, int velocityDelta) throws InvalidMidiDataException {
        int velocity = NoteMsg.getData2(msg) + velocityDelta;
        if (velocity > 127) {
            velocity = 127;
        } else if (velocity < 0) {
            velocity = 0;
        }
        return NoteMsg.setData2(msg, velocity);
    }
}

