/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midi.message;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import uk.org.toot.midi.message.ChannelMsg;

public class PitchMsg
extends ChannelMsg {
    public static boolean isPitch(MidiMessage msg) {
        return PitchMsg.isPitch(PitchMsg.getStatus(msg));
    }

    public static boolean isPitch(int status) {
        int cmd = PitchMsg.getCommand(status);
        return cmd == 144 || cmd == 128 || cmd == 160;
    }

    public static MidiMessage transpose(MidiMessage msg, int semitones) throws InvalidMidiDataException {
        int note = PitchMsg.getData1(msg) + semitones;
        if (note > 127) {
            note = 127;
        } else if (note < 0) {
            note = 0;
        }
        return PitchMsg.setData1(msg, note);
    }

    public static int getPitch(MidiMessage msg) {
        return PitchMsg.getData1(msg);
    }

    public static MidiMessage setPitch(MidiMessage msg, int pitch) throws InvalidMidiDataException {
        return PitchMsg.setData1(msg, pitch);
    }
}

