/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midi.misc;

import uk.org.toot.music.tonality.Pitch;

public class GM {
    public static final int ACOUSTIC_BASS_DRUM = 35;
    public static final int BASS_DRUM_1 = 36;
    public static final int SIDE_STICK = 37;
    public static final int ACOUSTIC_SNARE = 38;
    public static final int HAND_CLAP = 39;
    public static final int ELECTRIC_SNARE = 40;
    public static final int LOW_FLOOR_TOM = 41;
    public static final int CLOSED_HI_HAT = 42;
    public static final int HI_FLOOR_TOM = 43;
    public static final int PEDAL_HI_HAT = 44;
    public static final int LOW_TOM = 45;
    public static final int OPEN_HI_HAT = 46;
    public static final int LOW_MID_TOM = 47;
    public static final int HI_MID_TOM = 48;
    public static final int CRASH_CYMBAL_1 = 49;
    public static final int HI_TOM = 50;
    public static final int RIDE_CYMBAL_1 = 51;
    public static final int CHINESE_CYMBAL = 52;
    public static final int RIDE_BELL = 53;
    public static final int TAMBOURINE = 54;
    public static final int SPLASH_CYMBAL = 55;
    public static final int COWBELL = 56;
    public static final int CRASH_CYMBAL_2 = 57;
    public static final int VIBRASLAP = 58;
    public static final int RIDE_CYMBAL_2 = 59;
    public static final int HI_BONGO = 60;
    public static final int LOW_BONGO = 61;
    public static final int MUTE_HI_CONGA = 62;
    public static final int OPEN_HI_CONGA = 63;
    public static final int LOW_CONGA = 64;
    public static final int HI_TIMBALE = 65;
    public static final int LOW_TIMBALE = 66;
    public static final int HI_AGOGO = 67;
    public static final int LOW_AGOGO = 68;
    public static final int CABASA = 69;
    public static final int MARACAS = 70;
    public static final int SHORT_WHISTLE = 71;
    public static final int LONG_WHISTLE = 72;
    public static final int SHORT_GUIRO = 73;
    public static final int LONG_GUIRO = 74;
    public static final int CLAVES = 75;
    public static final int HI_WOOD_BLOCK = 76;
    public static final int LOW_WOOD_BLOCK = 77;
    public static final int MUTE_CUICA = 78;
    public static final int OPEN_CUICA = 79;
    public static final int MUTE_TRIANGLE = 80;
    public static final int OPEN_TRIANGLE = 81;
    public static final int[] HATS = new int[]{46, 42, 44};
    public static final int[] BASS_DRUMS = new int[]{35, 36};
    public static final int[] SNARES = new int[]{38, 40, 37, 39};
    public static final int[] TOMS = new int[]{50, 48, 47, 45, 43, 41};
    public static final int[] CYMBALS = new int[]{53, 51, 59, 49, 57, 52, 55};
    public static final int[] PERCS = new int[]{54, 56, 58, 69, 70, 75};
    public static final int[] MULTI_PERCS = new int[]{60, 61, 62, 63, 64, 65, 66, 67, 68, 71, 72, 73, 74, 76, 77, 78, 79, 80, 81};

    public static String melodicFamilyName(int family) {
        switch (family) {
            case 0: {
                return "Piano";
            }
            case 1: {
                return "Chromatic Percussion";
            }
            case 2: {
                return "Organ";
            }
            case 3: {
                return "Guitar";
            }
            case 4: {
                return "Bass";
            }
            case 5: {
                return "Solo Strings";
            }
            case 6: {
                return "Ensemble";
            }
            case 7: {
                return "Brass";
            }
            case 8: {
                return "Reed";
            }
            case 9: {
                return "Pipe";
            }
            case 10: {
                return "Synth Lead";
            }
            case 11: {
                return "Synth Pad";
            }
            case 12: {
                return "Synth Effects";
            }
            case 13: {
                return "Ethnic";
            }
            case 14: {
                return "Percussive";
            }
            case 15: {
                return "Sound Effects";
            }
        }
        return String.valueOf(family) + "?";
    }

    public static String melodicName(int program) {
        switch (program) {
            case 0: {
                return "Acoustic Grand Piano";
            }
            case 1: {
                return "Bright Acoustic Piano";
            }
            case 2: {
                return "Electric Grand Piano";
            }
            case 3: {
                return "Honky-tonk Piano";
            }
            case 4: {
                return "Rhodes Piano";
            }
            case 5: {
                return "Chorused Piano";
            }
            case 6: {
                return "Harpsichord";
            }
            case 7: {
                return "Clavinet";
            }
            case 8: {
                return "Celesta";
            }
            case 9: {
                return "Glockenspiel";
            }
            case 10: {
                return "Music Box";
            }
            case 11: {
                return "Vibraphone";
            }
            case 12: {
                return "Marimba";
            }
            case 13: {
                return "Xylophone";
            }
            case 14: {
                return "Tubular Bells";
            }
            case 15: {
                return "Dulcimer";
            }
            case 16: {
                return "Hammond Organ";
            }
            case 17: {
                return "Percussive Organ";
            }
            case 18: {
                return "Rock Organ";
            }
            case 19: {
                return "Church Organ";
            }
            case 20: {
                return "Reed Organ";
            }
            case 21: {
                return "Accordion";
            }
            case 22: {
                return "Harmonica";
            }
            case 23: {
                return "Tango Accordion";
            }
            case 24: {
                return "Acoustic Guitar (nylon)";
            }
            case 25: {
                return "Acoustic Guitar (steel)";
            }
            case 26: {
                return "Electric Guitar (jazz)";
            }
            case 27: {
                return "Electric Guitar (clean)";
            }
            case 28: {
                return "Electric Guitar (muted)";
            }
            case 29: {
                return "Overdriven Guitar";
            }
            case 30: {
                return "Distortion Guitar";
            }
            case 31: {
                return "Guitar Harmonics";
            }
            case 32: {
                return "Acoustic Bass";
            }
            case 33: {
                return "Electric Bass (finger)";
            }
            case 34: {
                return "Electric Bass (pick)";
            }
            case 35: {
                return "Fretless Bass";
            }
            case 36: {
                return "Slap Bass 1";
            }
            case 37: {
                return "Slap Bass 2";
            }
            case 38: {
                return "Synth Bass 1";
            }
            case 39: {
                return "Synth Bass 2";
            }
            case 40: {
                return "Violin";
            }
            case 41: {
                return "Viola";
            }
            case 42: {
                return "Cello";
            }
            case 43: {
                return "Contrabass";
            }
            case 44: {
                return "Tremelo Strings";
            }
            case 45: {
                return "Pizzicato Strings";
            }
            case 46: {
                return "Orchestral Harp";
            }
            case 47: {
                return "Timpani";
            }
            case 48: {
                return "String Ensemble 1";
            }
            case 49: {
                return "String Ensemble 2";
            }
            case 50: {
                return "SynthStrings 1";
            }
            case 51: {
                return "SynthStrings 2";
            }
            case 52: {
                return "Choir Aahs";
            }
            case 53: {
                return "Voice Oohs";
            }
            case 54: {
                return "Synth Voice";
            }
            case 55: {
                return "Orchestra Hit";
            }
            case 56: {
                return "Trumpet";
            }
            case 57: {
                return "Trombone";
            }
            case 58: {
                return "Tuba";
            }
            case 59: {
                return "Muted Trumpet";
            }
            case 60: {
                return "French Horn";
            }
            case 61: {
                return "Brass Section";
            }
            case 62: {
                return "Synth Brass 1";
            }
            case 63: {
                return "Synth Brass 2";
            }
            case 64: {
                return "Soprano Sax";
            }
            case 65: {
                return "Alto Sax";
            }
            case 66: {
                return "Tenor Sax";
            }
            case 67: {
                return "Baritone Sax";
            }
            case 68: {
                return "Oboe";
            }
            case 69: {
                return "English Horn";
            }
            case 70: {
                return "Bassoon";
            }
            case 71: {
                return "Clarinet";
            }
            case 72: {
                return "Piccolo";
            }
            case 73: {
                return "Flute";
            }
            case 74: {
                return "Recorder";
            }
            case 75: {
                return "Pan Flute";
            }
            case 76: {
                return "Bottle Blow";
            }
            case 77: {
                return "Shakuhachi";
            }
            case 78: {
                return "Whistle";
            }
            case 79: {
                return "Ocarina";
            }
            case 80: {
                return "Lead 1 (square)";
            }
            case 81: {
                return "Lead 2 (sawtooth)";
            }
            case 82: {
                return "Lead 3 (calliope lead)";
            }
            case 83: {
                return "Lead 4 (chiff lead)";
            }
            case 84: {
                return "Lead 5 (charang)";
            }
            case 85: {
                return "Lead 6 (voice)";
            }
            case 86: {
                return "Lead 7 (fifths)";
            }
            case 87: {
                return "Lead 8 (bass + lead)";
            }
            case 88: {
                return "Pad 1 (new age)";
            }
            case 89: {
                return "Pad 2 (warm)";
            }
            case 90: {
                return "Pad 3 (polysynth)";
            }
            case 91: {
                return "Pad 4 (choir)";
            }
            case 92: {
                return "Pad 5 (bowed)";
            }
            case 93: {
                return "Pad 6 (metallic)";
            }
            case 94: {
                return "Pad 7 (halo)";
            }
            case 95: {
                return "Pad 8 (sweep)";
            }
            case 96: {
                return "FX 1 (rain)";
            }
            case 97: {
                return "FX 2 (soundtrack)";
            }
            case 98: {
                return "FX 3 (crystal)";
            }
            case 99: {
                return "FX 4 (atmosphere)";
            }
            case 100: {
                return "FX 5 (brightness)";
            }
            case 101: {
                return "FX 6 (goblins)";
            }
            case 102: {
                return "FX 7 (echoes)";
            }
            case 103: {
                return "FX 8 (sci-fi)";
            }
            case 104: {
                return "Sitar";
            }
            case 105: {
                return "Banjo";
            }
            case 106: {
                return "Shamisen";
            }
            case 107: {
                return "Koto";
            }
            case 108: {
                return "Kalimba";
            }
            case 109: {
                return "Bagpipe";
            }
            case 110: {
                return "Fiddle";
            }
            case 111: {
                return "Shanai";
            }
            case 112: {
                return "Tinkle Bell";
            }
            case 113: {
                return "Agogo";
            }
            case 114: {
                return "Steel Drums";
            }
            case 115: {
                return "Woodblock";
            }
            case 116: {
                return "Taiko Drum";
            }
            case 117: {
                return "Melodic Tom";
            }
            case 118: {
                return "Synth Drum";
            }
            case 119: {
                return "Reverse Cymbal";
            }
            case 120: {
                return "Guitar Fret Noise";
            }
            case 121: {
                return "Breath Noise";
            }
            case 122: {
                return "Seashore";
            }
            case 123: {
                return "Bird Tweet";
            }
            case 124: {
                return "Telephone Ring";
            }
            case 125: {
                return "Helicopter";
            }
            case 126: {
                return "Applause";
            }
            case 127: {
                return "Gunshot";
            }
        }
        return String.valueOf(program) + "?";
    }

    public static int drumFamilyCount() {
        return 7;
    }

    public static String drumFamilyName(int f) {
        switch (f) {
            case 0: {
                return "Cymbals";
            }
            case 1: {
                return "Hi Hats";
            }
            case 2: {
                return "Snares";
            }
            case 3: {
                return "Toms";
            }
            case 4: {
                return "Bass Drums";
            }
            case 5: {
                return "Percussion";
            }
            case 6: {
                return "Multi Percussion";
            }
        }
        return "?";
    }

    public static int[] drumFamily(int f) {
        switch (f) {
            case 0: {
                return CYMBALS;
            }
            case 1: {
                return HATS;
            }
            case 2: {
                return SNARES;
            }
            case 3: {
                return TOMS;
            }
            case 4: {
                return BASS_DRUMS;
            }
            case 5: {
                return PERCS;
            }
            case 6: {
                return MULTI_PERCS;
            }
        }
        return null;
    }

    public static String drumName(int drum) {
        if (drum < 35 || drum > 81) {
            return Pitch.name(drum);
        }
        switch (drum) {
            case 35: {
                return "Acoustic Bass Drum";
            }
            case 36: {
                return "Bass Drum 1";
            }
            case 37: {
                return "Side Stick";
            }
            case 38: {
                return "Acoustic Snare";
            }
            case 39: {
                return "Hand Clap";
            }
            case 40: {
                return "Electric Snare";
            }
            case 41: {
                return "Low Floor Tom";
            }
            case 42: {
                return "Closed Hi-Hat";
            }
            case 43: {
                return "High Floor Tom";
            }
            case 44: {
                return "Pedal Hi-Hat";
            }
            case 45: {
                return "Low Tom";
            }
            case 46: {
                return "Open Hi-Hat";
            }
            case 47: {
                return "Low-Mid Tom";
            }
            case 48: {
                return "Hi-Mid Tom";
            }
            case 49: {
                return "Crash Cymbal 1";
            }
            case 50: {
                return "High Tom";
            }
            case 51: {
                return "Ride Cymbal 1";
            }
            case 52: {
                return "Chinese Cymbal";
            }
            case 53: {
                return "Ride Bell";
            }
            case 54: {
                return "Tambourine";
            }
            case 55: {
                return "Splash Cymbal";
            }
            case 56: {
                return "Cowbell";
            }
            case 57: {
                return "Crash Cymbal 2";
            }
            case 58: {
                return "Vibraslap";
            }
            case 59: {
                return "Ride Cymbal 2";
            }
            case 60: {
                return "Hi Bongo";
            }
            case 61: {
                return "Low Bongo";
            }
            case 62: {
                return "Mute Hi Conga";
            }
            case 63: {
                return "Open Hi Conga";
            }
            case 64: {
                return "Low Conga";
            }
            case 65: {
                return "High Timbale";
            }
            case 66: {
                return "Low Timbale";
            }
            case 67: {
                return "High Agogo";
            }
            case 68: {
                return "Low Agogo";
            }
            case 69: {
                return "Cabasa";
            }
            case 70: {
                return "Maracas";
            }
            case 71: {
                return "Short Whistle";
            }
            case 72: {
                return "Long Whistle";
            }
            case 73: {
                return "Short Guiro";
            }
            case 74: {
                return "Long Guiro";
            }
            case 75: {
                return "Claves";
            }
            case 76: {
                return "Hi Wood Block";
            }
            case 77: {
                return "Low Wood Block";
            }
            case 78: {
                return "Mute Cuica";
            }
            case 79: {
                return "Open Cuica";
            }
            case 80: {
                return "Mute Triangle";
            }
            case 81: {
                return "Open Triangle";
            }
        }
        return String.valueOf(drum) + "?";
    }
}

