/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midi.sequencer;

import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.ShortMessage;
import uk.org.toot.midi.sequencer.JSSecurityManager;
import uk.org.toot.midi.sequencer.Printer;

class EventDispatcher
implements Runnable {
    private ArrayList<EventInfo> eventQueue = new ArrayList();
    private Thread thread = null;

    EventDispatcher() {
    }

    synchronized void start() {
        if (this.thread == null) {
            this.thread = JSSecurityManager.createThread(this, "Java Sound Event Dispatcher", true, -1, true);
        }
    }

    protected void processEvent(EventInfo eventInfo) {
        int count = eventInfo.getListenerCount();
        if (eventInfo.getEvent() instanceof MetaMessage) {
            MetaMessage event = (MetaMessage)eventInfo.getEvent();
            int i = 0;
            while (i < count) {
                try {
                    ((MetaEventListener)eventInfo.getListener(i)).meta(event);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++i;
            }
            return;
        }
        if (eventInfo.getEvent() instanceof ShortMessage) {
            ShortMessage event = (ShortMessage)eventInfo.getEvent();
            int status = event.getStatus();
            if ((status & 0xF0) == 176) {
                int i = 0;
                while (i < count) {
                    try {
                        ((ControllerEventListener)eventInfo.getListener(i)).controlChange(event);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            return;
        }
        Printer.err("Unknown event type: " + eventInfo.getEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvents() {
        EventInfo eventInfo = null;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            try {
                if (this.eventQueue.size() == 0) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.eventQueue.size() > 0) {
                eventInfo = this.eventQueue.remove(0);
            }
        }
        if (eventInfo != null) {
            this.processEvent(eventInfo);
        }
    }

    private synchronized void postEvent(EventInfo eventInfo) {
        this.eventQueue.add(eventInfo);
        this.notifyAll();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.dispatchEvents();
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    void sendAudioEvents(Object event, List listeners) {
        if (listeners == null || listeners.size() == 0) {
            return;
        }
        this.start();
        EventInfo eventInfo = new EventInfo(event, listeners);
        this.postEvent(eventInfo);
    }

    private class EventInfo {
        private Object event;
        private Object[] listeners;

        EventInfo(Object event, List listeners) {
            this.event = event;
            this.listeners = listeners.toArray();
        }

        Object getEvent() {
            return this.event;
        }

        int getListenerCount() {
            return this.listeners.length;
        }

        Object getListener(int index) {
            return this.listeners[index];
        }
    }
}

