/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midix.control.neck;

import java.util.ArrayList;

public class ChordShape {
    private ArrayList<Fretting> fretting = new ArrayList();

    public Fretting getFretting(int string) {
        return this.fretting.get(string);
    }

    public int bias() {
        int bias = 0;
        for (Fretting f : this.fretting) {
            if (f.isMuted() || f.finger < 0) continue;
            bias += f.fret;
        }
        return bias;
    }

    public ChordShape add(int fret, int finger) {
        this.fretting.add(new Fretting(fret, finger));
        return this;
    }

    public ChordShape addMute() {
        this.fretting.add(new Fretting(-1, -1));
        return this;
    }

    public boolean isValidAt(int fret) {
        for (Fretting f : this.fretting) {
            if (f.isMuted() || f.finger < 0 || fret + f.fret >= 0) continue;
            return false;
        }
        return true;
    }

    public class Fretting {
        public int fret = 0;
        public int finger = 0;

        public Fretting(int aFret, int aFinger) {
            this.fret = aFret;
            this.finger = aFinger;
        }

        public boolean isMuted() {
            return this.fret == -1 && this.finger == -1;
        }
    }
}

