/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midix.control.neck;

import java.util.ArrayList;
import java.util.List;
import uk.org.toot.midi.core.AbstractMidiDevice;
import uk.org.toot.midi.core.channel.ChannelWriteMidiOutput;
import uk.org.toot.midi.core.channel.MidiChannelWriter;
import uk.org.toot.midix.control.neck.Bendable;
import uk.org.toot.midix.control.neck.ChordShape;
import uk.org.toot.midix.control.neck.NeckFamily;
import uk.org.toot.midix.control.neck.StringTuning;
import uk.org.toot.midix.control.neck.Tunings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrungNeck
extends AbstractMidiDevice
implements Bendable {
    private static int nextNum = 1;
    private int num = nextNum++;
    private List<TunedString> strings;
    private int frets = 24;
    private int barreSize = 6;
    private boolean octaveStrings = false;
    private ChannelWriteMidiOutput outPort;
    private NeckFamily family;
    private StringTuning tuning;
    private String name;

    public StrungNeck(NeckFamily family) {
        this(family, 24);
    }

    public StrungNeck(NeckFamily family, int nfrets) {
        super("Neck");
        this.name = "Neck " + this.num + ": " + family.getName();
        this.outPort = new ChannelWriteMidiOutput(this.name);
        this.addMidiOutput(this.outPort);
        this.family = family;
        this.frets = nfrets;
        Tunings t = family.getTunings();
        String tuning = t.getTunings().get(0);
        StringTuning st = t.createTuning(tuning);
        this.setTuning(st);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setTuning(StringTuning tuning) {
        this.strings = new ArrayList<TunedString>();
        int i = 0;
        while (i < tuning.getPolyphony()) {
            this.strings.add(new TunedString(i, this.outPort.getChannelWriter(i)));
            ++i;
        }
        this.tuning = tuning;
    }

    public StringTuning getTuning() {
        return this.tuning;
    }

    public NeckFamily getFamily() {
        return this.family;
    }

    public List<TunedString> getStrings() {
        return this.strings;
    }

    public TunedString getString(int index) {
        if (index < 0 || index >= this.getStringCount()) {
            return null;
        }
        return this.strings.get(index);
    }

    public int getStringCount() {
        return this.strings.size();
    }

    public int getFrets() {
        return this.frets;
    }

    public void setBarreSize(int size) {
        this.barreSize = size;
    }

    public int getBarreSize() {
        return this.barreSize;
    }

    public void barre(int fret) {
        int i = 0;
        while (i < this.strings.size()) {
            if (i < this.getStringCount() - this.getBarreSize()) {
                this.strings.get(i).hold(0);
            } else {
                this.strings.get(i).hold(fret);
            }
            ++i;
        }
    }

    public void shape(int offset, ChordShape shape, int firstString) {
        int i = 0;
        while (i < this.strings.size()) {
            TunedString string = this.strings.get(i);
            if (shape == null) {
                string.hold(0);
            } else if (i - firstString < 0) {
                string.mute(0);
            } else {
                ChordShape.Fretting f = shape.getFretting(i - firstString);
                if (f.finger == -1) {
                    string.hold(f.fret);
                } else if (offset + f.fret >= 0) {
                    string.hold(offset + f.fret);
                } else {
                    string.mute(0);
                }
            }
            ++i;
        }
    }

    public void mute() {
        for (TunedString string : this.strings) {
            string.mute();
        }
    }

    protected void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void bend(int amount) {
        for (TunedString string : this.strings) {
            if (!string.isBending() && amount != 0) continue;
            string.bend(amount);
        }
    }

    public boolean isBending() {
        for (TunedString string : this.strings) {
            if (!string.isBending()) continue;
            return true;
        }
        return false;
    }

    public void setProgram(int prg) {
        this.mute();
        for (TunedString string : this.strings) {
            string.programChange(prg);
        }
    }

    public void setOctaveStrings(boolean oct) {
        this.octaveStrings = oct;
        for (TunedString string : this.strings) {
            string.setOctave(oct);
        }
    }

    public boolean hasOctaveStrings() {
        return this.octaveStrings;
    }

    public class TunedString
    implements Bendable {
        private int fret = 0;
        private int note = -1;
        private int chan;
        private boolean octave = false;
        private int diatonics = 0;
        private boolean bending = false;
        private MidiChannelWriter channel;

        public TunedString(int aChan, MidiChannelWriter channel) {
            this.chan = aChan;
            this.channel = channel;
        }

        public int getChannel() {
            return this.chan;
        }

        public int getOpenTuning() {
            return StrungNeck.this.getTuning().getPitch(this.chan);
        }

        public int getDoubleInterval() {
            return StrungNeck.this.getTuning().getDoubleInterval(this.chan);
        }

        public int getNote() {
            return this.note;
        }

        public int getFret() {
            return this.fret;
        }

        public void setOctave(boolean oct) {
            this.octave = oct;
        }

        public void hold(int aFret) {
            this.fret = aFret;
        }

        public void mute(int aFret) {
            this.fret = -aFret;
        }

        public void open() {
            this.fret = 0;
        }

        public void pick(boolean up, int velocity) {
            this.mute();
            if (this.fret < 0) {
                return;
            }
            if (velocity < 10) {
                velocity = 10;
            }
            this.note = this.getOpenTuning() + this.fret;
            if (up && this.octave && this.note < 127 - this.getDoubleInterval()) {
                this.channel.noteOn(this.note + this.getDoubleInterval(), velocity);
                StrungNeck.this.sleep(10L);
            }
            this.channel.noteOn(this.note, velocity);
            if (!up && this.octave && this.note < 127 - this.getDoubleInterval()) {
                StrungNeck.this.sleep(10L);
                this.channel.noteOn(this.note + this.getDoubleInterval(), velocity);
            }
        }

        public void mute() {
            if (this.note < 0) {
                return;
            }
            this.channel.noteOff(this.note);
            if (this.octave) {
                this.channel.noteOff(this.note + this.getDoubleInterval());
            }
            this.note = -1;
        }

        public void bend(int bend) {
            this.channel.setPitchBend(bend);
        }

        public void programChange(int prg) {
            this.channel.programChange(prg);
        }

        public boolean isBending() {
            return this.bending;
        }

        public void setBending(boolean b) {
            this.bending = b;
        }

        public boolean diatonic(int fret) {
            return (this.diatonics & 1 << fret) != 0;
        }

        public void diatonics(int mask) {
            this.diatonics = mask;
        }
    }
}

