/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.music;

import uk.org.toot.music.TimedCoding;

public class KeyCoding
extends TimedCoding {
    private static final int ROOT_SHIFT = 12;
    private static final int ROOT_MASK = 15;
    private static final int INTERVAL_SHIFT = 0;
    private static final int INTERVAL_MASK = 2047;

    public static int create(int time, int root, int intervals) {
        int key = KeyCoding.create(time);
        key = KeyCoding.setRoot(key, root);
        key = KeyCoding.setIntervals(key, intervals);
        return key;
    }

    public static int getRoot(int key) {
        return key >> 12 & 0xF;
    }

    public static int setRoot(int key, int root) {
        key &= 0xFFFF0FFF;
        return key |= (root & 0xF) << 12;
    }

    public static int getIntervals(int key) {
        return key >> 0 & 0x7FF;
    }

    public static int setIntervals(int key, int intervals) {
        key &= 0xFFFFF800;
        return key |= (intervals & 0x7FF) << 0;
    }
}

