/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.music;

import uk.org.toot.music.TimedCoding;

public class Note
extends TimedCoding {
    private static final int DURATION_SHIFT = 16;
    private static final int DURATION_MASK = 255;
    private static final int PITCH_SHIFT = 8;
    private static final int PITCH_MASK = 127;
    private static final int LEVEL_MASK = 127;

    public static int create(int timeOn, int pitch, int level) {
        int note = Note.create(timeOn);
        note = Note.setDuration(note, 1);
        note = Note.setPitch(note, pitch);
        note = Note.setLevel(note, level);
        return note;
    }

    public static int getDuration(int note) {
        return note >> 16 & 0xFF;
    }

    public static int setDuration(int note, int time) {
        note &= 0xFF00FFFF;
        return note |= (time & 0xFF) << 16;
    }

    public static int getPitch(int note) {
        return note >> 8 & 0x7F;
    }

    public static int setPitch(int note, int pitch) {
        note &= 0xFFFF80FF;
        return note |= (pitch & 0x7F) << 8;
    }

    public static int getLevel(int note) {
        return note & 0x7F;
    }

    public static int setLevel(int note, int level) {
        note &= 0xFFFFFF80;
        return note |= level & 0x7F;
    }
}

