/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.music.performance;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Track;
import uk.org.toot.midi.message.ChannelMsg;
import uk.org.toot.music.Note;
import uk.org.toot.music.performance.Instrument;

public class Performer {
    private String name;
    private Instrument instrument;
    private float swingRatio = 1.0f;

    public Performer(String name, Instrument instrument) {
        this.name = name;
        this.instrument = instrument;
    }

    public String getName() {
        return this.name;
    }

    public void renderBar(int[] notes, Track track, long startTick, int ticksPerBar) throws InvalidMidiDataException {
        int channel = this.getInstrument().getChannel();
        int i = 0;
        while (i < notes.length) {
            int note = notes[i];
            float timeOn = this.swing(Note.getTime(note));
            int pitch = Note.getPitch(note);
            int level = Note.getLevel(note);
            long onTick = (int)((float)ticksPerBar * timeOn / 64.0f);
            MidiMessage msg = ChannelMsg.createChannel(144, channel, pitch, level);
            track.add(new MidiEvent(msg, startTick + onTick));
            msg = ChannelMsg.createChannel(128, channel, pitch, 0);
            float timeOff = this.swing(Note.getTime(note) + Note.getDuration(note));
            long offTick = (int)((float)ticksPerBar * timeOff / 64.0f);
            track.add(new MidiEvent(msg, startTick + offTick));
            ++i;
        }
    }

    public float getSwingRatio() {
        return this.swingRatio;
    }

    public void setSwingRatio(float ratio) {
        this.swingRatio = ratio;
    }

    public float swing(int time) {
        float swingFactor = this.swingRatio - 1.0f;
        double angle = -1.5707963267948966 + Math.PI * 2 * (double)(time % 16) / 16.0;
        return (float)((double)time + (double)(4.0f * swingFactor) * (Math.sin(angle) + 1.0) / 2.0);
    }

    public void checkSwing() {
        int i = 0;
        while (i < 64) {
            System.out.println(String.valueOf(i) + " => " + this.swing(i));
            ++i;
        }
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }
}

