/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.music.tonality;

import uk.org.toot.music.tonality.ChordMode;

public class Scale {
    private String name;
    private int[] intervals;
    private int intIntervals;

    public Scale(String name, int[] intervals) {
        this.name = name;
        this.intervals = intervals;
        int i = 0;
        while (i < intervals.length) {
            this.intIntervals |= 1 << intervals[i];
            ++i;
        }
    }

    public int length() {
        return this.intervals.length;
    }

    public String getName() {
        return this.name;
    }

    public int[] getIntervals() {
        return this.intervals;
    }

    public int getIntervalsAsInt() {
        return this.intIntervals;
    }

    public int interval(int index) {
        return ChordMode.interval(this.intervals, index);
    }

    public int interval(int index1, int index2) {
        return ChordMode.interval(this.intervals, index1, index2);
    }

    public int[] getChordMode(int index) {
        int[] modeIntervals = new int[this.length()];
        int i = 1;
        while (i < this.length()) {
            modeIntervals[i] = modeIntervals[i - 1] + this.interval(index + i - 1, index + i);
            ++i;
        }
        return modeIntervals;
    }

    public boolean hasInterval(int index, int val) {
        int i2 = (this.interval(index) + val) % 12;
        int i = 0;
        while (i < this.length()) {
            if (i2 == this.interval(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

