/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.service;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import uk.org.toot.service.ServiceDescriptor;
import uk.org.toot.service.ServiceVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceProvider {
    protected final int providerId;
    protected String providerName;
    protected String version;
    protected String description;
    private Hashtable<Class<?>, List<ServiceDescriptor>> services = new Hashtable();

    public ServiceProvider(int providerId, String providerName, String description, String version) {
        if (providerName == null) {
            throw new IllegalArgumentException("providerName == null!");
        }
        if (version == null) {
            throw new IllegalArgumentException("version == null!");
        }
        if (description == null) {
            throw new IllegalArgumentException("description == null!");
        }
        this.providerId = providerId;
        this.providerName = providerName;
        this.description = description;
        this.version = version;
    }

    public int getProviderId() {
        return this.providerId;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription(Locale locale) {
        return this.description;
    }

    protected List<ServiceDescriptor> service(Class<?> serviceClass) {
        if (this.services.get(serviceClass) == null) {
            this.services.put(serviceClass, new ArrayList());
        }
        return this.services.get(serviceClass);
    }

    protected void add(ServiceDescriptor d) {
        for (Class<?> clazz : this.services.keySet()) {
            if (!clazz.isAssignableFrom(d.getServiceClass())) continue;
            this.services.get(clazz).add(d);
            return;
        }
    }

    protected void add(Class clazz, String name, String description, String version) {
        this.add(new ServiceDescriptor(clazz, name, description, version));
    }

    public void accept(ServiceVisitor v, Class<?> clazz) {
        v.visitProvider(this);
        if (clazz == null) {
            for (Class<?> c : this.services.keySet()) {
                this.visit(v, this.services.get(c).iterator());
            }
        } else {
            this.visit(v, this.services.get(clazz).iterator());
        }
    }

    protected void visit(ServiceVisitor v, Iterator<ServiceDescriptor> dit) {
        while (dit.hasNext()) {
            v.visitDescriptor(dit.next());
        }
    }

    public String toString() {
        return String.valueOf(this.description) + " v" + this.version + " by " + this.providerName;
    }
}

