/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.audioui.meterui;

import java.awt.Dimension;
import java.util.Observable;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import uk.org.toot.audio.core.ChannelFormat;
import uk.org.toot.audio.meter.MeterControls;
import uk.org.toot.control.Control;
import uk.org.toot.swingui.controlui.ControlPanel;

public class MeterOversPanel
extends ControlPanel {
    private MeterControls controls;
    private JLabel leftOvers;
    private JLabel rightOvers;
    private JLabel centerOvers;
    private int[] left;
    private int[] right;
    private int center;

    public MeterOversPanel(Control indicator) {
        super(indicator);
        this.setLayout(new BoxLayout(this, 0));
        this.controls = (MeterControls)indicator.getParent();
        ChannelFormat format = this.controls.getChannelFormat();
        this.center = format.getCenter();
        this.left = format.getLeft();
        this.right = format.getRight();
        if (this.left != null) {
            this.leftOvers = new OverLabel();
            this.add(this.leftOvers);
        }
        if (this.center >= 0) {
            this.centerOvers = new OverLabel();
            this.centerOvers.setHorizontalAlignment(0);
            this.add(this.centerOvers);
        }
        if (this.right != null) {
            this.rightOvers = new OverLabel();
            this.rightOvers.setHorizontalAlignment(4);
            this.add(this.rightOvers);
        }
    }

    public void update(Observable obs, Object obj) {
        int i;
        int overs;
        if (this.leftOvers != null) {
            overs = 0;
            i = 0;
            while (i < this.left.length) {
                overs += this.controls.getState((int)this.left[i]).overs;
                ++i;
            }
            this.leftOvers.setText(overs < 100 ? String.valueOf(overs) : "^^");
        }
        if (this.centerOvers != null) {
            overs = this.controls.getState((int)this.center).overs;
            this.centerOvers.setText(overs < 100 ? String.valueOf(overs) : "^^");
        }
        if (this.rightOvers != null) {
            overs = 0;
            i = 0;
            while (i < this.left.length) {
                overs += this.controls.getState((int)this.right[i]).overs;
                ++i;
            }
            this.rightOvers.setText(overs < 100 ? String.valueOf(overs) : "^^");
        }
    }

    public static class OverLabel
    extends JLabel {
        public OverLabel() {
            super("0");
        }

        public Dimension getMaximumSize() {
            Dimension d = super.getMaximumSize();
            d.height = 22;
            d.width = 22;
            return d;
        }
    }
}

